@extends('layouts.admin')

@section('content')
    <h1>Audit</h1>

    <!-- Mailing list Form Upload -->
    <div class="alert alert-success alert-dismissible fade in" style="display:none">
        <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
        <strong>Success!</strong> <span class="message"></span>
    </div>
    <div class="spinner text-center" style="display:none">
        <i class="fa fa-spinner fa-spin"></i>
    </div>
    @if (session('message'))
        <div class="alert alert-success">
            <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
            <p>{{ session('message') }}</p>
        </div>
    @endif
    <div id="imported_files" class="modal fade" role="dialog">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">Imported Files</h4>
                </div>
                <div class="modal-body"></div>
            </div>
        </div>
    </div>
    <div class="text-right remove-file">
        <button type="button" class="btn btn-danger" data-toggle="modal" id="open_imported_files" data-target="#imported_files">Remove Imported File</button>
    </div>
    <div class="well">
        <form action="{{ route('importExcel') }}" method="post" enctype="multipart/form-data" id="import_file">
            <h4 class="text-primary">Upload form</h4>
            {{ csrf_field() }}
            <div class="row">
                <div class="col-sm-5">
                    <div class="form-group">
                        <select class="form-control" name="edition">
                            <?= $options ?>
                        </select>
                        <span class="help-block">
                            <strong class="edition-error"></strong>
                        </span>
                    </div>
                </div>
                <div class="col-sm-5">
                    <div class="form-group file-input">
                        <input type="file" name="import_file" />
                        <button type="button" class="btn btn-block">Choose File</button>
                        <span class="help-block">
                            <strong class="import_file-error"></strong>
                        </span>
                    </div>
                </div>
                <div class="col-sm-2">
                    <div class="form-group">
                        <button type="submit" class="btn btn-primary btn-block">Import File</button>
                    </div>
                </div>
            </div>
        </form>
    </div>
    <div class="info-block">
        <h4 class="text-primary">Select Edition to View Data</h4>

        <!-- Mailing list Form Select -->
        <div class="form-group">
            <select class="form-control" name="edition" id="mailing_list">
                <?= $data_options ?>
            </select>
        </div>

        <div id="filter_container"></div>
    </div>

@endsection()

@push('scripts')
    <script>

        "use strict";

        $(function () {

            $('#open_imported_files').click(function(){
                $.get('/subscriber/getfiles', {}, function (data) {
                    if (data == '') {
                        $('#imported_files .modal-body').html("There are no file imported.");
                    } else {
                        $('#imported_files .modal-body').html(data);
                    }
                });
            })

            var form = $('#import_file');

            form.submit(function(e) {
                e.preventDefault();
                var formData = new FormData($(this)[0]);
                $('.spinner').fadeIn();
                setTimeout(function(){
                    $.ajax({
                        url     : form.attr('action'),
                        type    : form.attr('method'),
                        data: formData,
                        async: false,
                        cache: false,
                        contentType: false,
                        processData: false,
                        success : function (json) {
                            $('.spinner').fadeOut();
                            $('.form-group').removeClass('has-error');
                            $('.form-group').find('strong').html('');
                            $('.alert-success p').html(json.message);
                            $('.alert-success').fadeIn();
                            setTimeout(function(){
                                $('.alert-success').fadeOut();
                            },5000)
                        },
                        error: function(json) {
                            $('.spinner').fadeOut();
                            $('.form-group').removeClass('has-error');
                            $('.form-group').find('strong').html('');
                            if(json.status === 422) {
                                var errors = json.responseJSON.errors;
                                $.each(errors, function (key, value) {
                                    $('.'+key+'-error').closest('.form-group').addClass('has-error');
                                    $('.'+key+'-error').html(value);
                                });
                            } else {
                                // Error
                            }
                        }
                    });
                }, 1000)
            });

            $('#mailing_list').change(function () {

                var mailing_list = $(this).val();

                $.get('/subscriber/audit/filters', {mailing_list: mailing_list}, function (data) {

                    $('#filter_container').html(data);
                });
            })
        });
        function ConfirmDelete() {
            var x = confirm("Are you sure you want to delete this file?");
            if (x)
                return true;
            else
                return false;
        }
    </script>
@endpush
