@extends('layouts.admin')

@section('content')
    <h1>Audit</h1>

    <!-- Mailing list Form Select -->
    <div class="form-group">
    {!! Form::label('mailing_list', 'Mailing list') !!}
    {!! Form::select('mailing_list', $mailing_lists ?? [], null, ['id' => 'mailing_list', 'class' => 'form-control', 'placeholder' => 'Mailing Lists']) !!}
    </div>

    <div id="filter_container"></div>
@endsection()

@push('scripts')
    <script>

        "use strict";

        $(function () {

            $('#mailing_list').change(function () {

                var mailing_list = $(this).val();

                $.get('/subscriber/audit/filters', {mailing_list: mailing_list}, function (data) {

                    $('#filter_container').html(data);
                });
            })
        });
    </script>
@endpush
