@extends('layouts.admin', ['container' => 'container-fluid'])

@section('content')

    @include('admin.partials.index_page.heading', ['title' => 'Changed Data Report'])
    <div class="modal fade" id="changes" role="dialog">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">Changed Data</h4>
                </div>
                <div class="modal-body"></div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <form class="form-inline filter-form" action="/{{ \Request::path() }}" method="get">
                <div class="form-group">
                    <label for="from">Changed Date From:</label>
                    <input type="date" class="form-control"  name="from" value="{{ \Request::has('from')?\Request::get('from'):'' }}">
                </div>
                <div class="form-group">
                    <label for="to">Changed Date To:</label>
                    <input type="date" class="form-control" name="to" value="{{ \Request::has('to')?\Request::get('to'):'' }}">
                </div>
                <button type="submit" class="btn btn-primary">Filter</button>
                <a href="/{{ \Request::path() }}" class="btn btn-default">Reset</a>
            </form>
        </div>
    </div>
    <div id="subscriber_table_container" class="subscribers-container subscribers-changes">
        <div class="table-responsive">
            {!! $grid !!}
        </div>
    </div>
@endsection

@push('scripts')
    <script>

        "use strict";

        $(function () {
            var table_container = $('#filter');

            $('.subscribers-changes .table .text-danger').click(function(){
                var subscriber_id = $(this).closest('tr').data('id');

                $.post('/subscriber/get_changes', {subscriber_id: subscriber_id}, function (data) {
                    console.log(data);
                    $('#changes').find('.modal-body').html(data);
                    $('#changes').modal('show');
                });
            })
        });
    </script>
@endpush
