@extends('layouts.admin')

@section('content')
    <div class="row">
        <div class="col-md-12">
            <h1 class="page-heading">Daily Subscriber Report</h1>
            <form class="form-inline filter-form" action="/{{ \Request::path() }}" method="get">
                <div class="form-group">
                    <label for="from">From Date:</label>
                    <input type="date" class="form-control"  name="from" value="{{ \Request::has('from')?\Request::get('from'):'' }}">
                </div>
                <div class="form-group">
                    <label for="to">To Date:</label>
                    <input type="date" class="form-control" name="to" value="{{ \Request::has('to')?\Request::get('to'):'' }}">
                </div>
                <button type="submit" class="btn btn-primary">Filter</button>
                <a href="/{{ \Request::path() }}" class="btn btn-default">Reset</a>
            </form>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <table class="table table-striped">
                <thead>
                <tr>
                    <th>Date</th>
                    <th>Digital Magazine</th>
                    <th>Newsletter</th>
                </tr>
                </thead>
                <tbody>
                @if(isset($daily_subscribers_report))
                    @foreach($daily_subscribers_report AS $item)
                        <tr>
                            <td>{{ $item->date }}</td>
                            <td><a href="/subscriber/list/{{ date_format(date_create($item->date),'Y-m-d') . '/4' }}">{{ $item->dcount }}</a></td>
                            <td><a href="/subscriber/list/{{ date_format(date_create($item->date),'Y-m-d') . '/5' }}">{{ $item->ncount }}</a></td>
                        </tr>
                    @endforeach
                @endif
                </tbody>
            </table>
        </div>
    </div>
@endsection()
