@extends('layouts.admin')

@section('content')
    <div class="row">
        <div class="col-md-12">
            <h3>Daily Subscriber Report</h3>
            <form class="form-inline" action="/{{ \Request::path() }}" method="get">
                <div class="form-group">
                    <label for="from">From Date:</label>
                    <input type="date" class="form-control"  name="from" value="{{ \Request::has('from')?\Request::get('from'):'' }}">
                </div>
                <div class="form-group">
                    <label for="to">To Date:</label>
                    <input type="date" class="form-control" name="to" value="{{ \Request::has('to')?\Request::get('to'):'' }}">
                </div>
                <button type="submit" class="btn btn-primary">Filter</button>
                <a href="/{{ \Request::path() }}" class="btn btn-default">Reset</a>
            </form>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <table class="table table-striped">
                <thead>
                <tr>
                    <th>Date</th>
                    <th>Digital Magazine</th>
                    <th>Newsletter</th>
                </tr>
                </thead>
                <tbody>
                @if(isset($daily_subscribers_report))
                    @foreach($daily_subscribers_report AS $item)
                        <tr data-path="/subscriber/list/{{ date_format(date_create($item->date),'Y-m-d') . '/'  . $item->list_id }}" class="subscription_data">
                            <td>{{ $item->date }}</td>
                            @if ($item->list_id == 4)
                                <td>{{ $item->total }}</td>
                                <td></td>
                            @elseif ($item->list_id == 5)
                                <td></td>
                                <td>{{ $item->total }}</td>
                            @endif
                        </tr>
                    @endforeach
                @endif
                </tbody>
            </table>
        </div>
    </div>
@endsection()

@push('scripts')
    <script>

        "use strict";

        $(function () {
            var table_container = $('.table');

            table_container.on('click', '.subscription_data', function () {
                //parent is where the path data is held
                window.location.href = $(this).data('path');
            });
        });
    </script>
@endpush
