<!-- Email Form Text -->
<div id="email_container" class="form-group {{ (!empty(old('email')) && !$errors->has('email')) || (isset($subscriber) && !empty($subscriber->email)) ? 'has-success' : 'has-error' }}">
    {!! Form::label('email', 'Email') !!}
    {!! Form::text('email', NULL, ['id' => 'email', 'class' => 'subscriber_data form-control']) !!}
</div>

<!-- firstname Form Text -->
<div class="form-group">
    {!! Form::label('firstname', 'First Name') !!}
    {!! Form::text('firstname', NULL, ['class' => 'form-control subscriber_data']) !!}
</div>

<!-- lastname Form Text -->
<div class="form-group">
    {!! Form::label('lastname', 'Last Name') !!}
    {!! Form::text('lastname', NULL, ['class' => 'form-control subscriber_data']) !!}
</div>

<!-- company Form Text -->
<div class="form-group">
    {!! Form::label('company', 'Company') !!}
    {!! Form::text('company', NULL, ['class' => 'form-control subscriber_data']) !!}
</div>

@if(Auth::user())

    <!-- subscriber_source_id Form Select -->
    <div class="form-group">
        {!! Form::label('subscriber_source_id', 'Source') !!}
        {!! Form::select('subscriber_source_id', $subscriber_sources ?? [], isset($subscriber) ? $subscriber->subscriber_source_id : '', ['class' => 'form-control', 'placeholder' => 'Please choose a Source']) !!}
    </div>

    <!-- note Form Textarea -->
    <div class="form-group">
        {!! Form::label('note', 'note') !!}
        {!! Form::textarea('note', NULL, ['class' => 'form-control']) !!}
    </div>
@else

    <!-- Subscriber Source ID Form Hidden -->
    {!! Form::hidden('subscriber_source_id', '1', ['id' => 'subscriber_source_id']) !!}
@endif

@include('admin.subscribers.partials.personal_information')

@include('admin.subscribers.partials.questions')

<!-- Form Submit -->
<div class="form-group">
    {!! Form::submit($submit_title, ['class' => 'btn btn-primary form-control']) !!}
</div>

@include('admin.partials.reload')

@push('scripts')
    <script>

        "use strict";

        $(function () {

            $('#email').keyup(function () {

                check_email_validation($(this), this.value);
            }).change(function () {

                check_email_validation($(this), this.value);
            });
        });


        function check_email_validation(curr_obj, value) {

            if (value !== '') {

                curr_obj.parent('div').removeClass('has-error').addClass('has-success');
            } else {

                curr_obj.parent('div').removeClass('has-success').addClass('has-error');
            }
        }
    </script>
@endpush
