@extends('layouts.admin', ['container' => 'container-fluid'])

@section('content')

    @include('admin.partials.index_page.heading', ['title' => 'Subscribers'])

    <div class="row">
        <div class="col-sm-12 action-box">
            <p>
                <a href="/subscriber/create" class="btn btn-primary pull-left">Create</a>
                <!-- <button type="button" class="btn btn-success pull-right" id="sync">Sync</button> -->
            </p>
        </div>
    </div>

    {!! Form::open(['method' => 'post', 'action' => ['SubscribersController@send_request'], 'class' => 'request_form']) !!}
    {!! Form::hidden('name', Auth::user()->name, []) !!}
    {!! Form::hidden('email', Auth::user()->email, []) !!}
    <!-- Delete Form Submit -->
    {!! Form::close() !!}

    @if (session('message'))
        <div class="alert alert-success">
            <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
            <p>{{ session('message') }}</p>
        </div>
    @endif
    @if (session('error'))
        <div class="alert alert-danger">
            <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
            <p>{{ session('error') }}</p>
        </div>
    @endif

    <div id="subscriber_table_container" class="subscribers-container">
        {!! $grid !!}
    </div>
@endsection

@push('scripts')
    <script>

        "use strict";

        $(function () {
            var table_container = $('#filter');

            table_container.on('click', '.edit_data td:not(.column-)', function () {
                //parent is where the path data is held
                window.location.href = $(this).parent('tr').data('path');
            });

            $('#request_excel_download').click(function(){
                $('.request_form').submit();
            })

            $('.excel-export').click(function(){
                $.post('/subscriber/export');
            })

            $('#sync').click(function(){
                $.post('/subscriber/sync', {}, function (data) {
                    console.log(data);
                });
            })
        });
    </script>
@endpush
