@extends('layouts.admin')

@section('content')

    @include('admin.partials.index_page.heading', ['title' => $heading_title])

    @include('admin.partials.index_page.create_button', ['title' => $create_button_title])

    <div class="row">
        <div class="col-sm-6">
            <!-- Query Form Text -->
            <div class="form-group">
                {!! Form::label('id', 'ID') !!}
                {!! Form::text('id', Request::input('id'), ['class' => 'form-control search_data', 'data-search_name' => 'id', 'placeholder' => 'Enter something to search...']) !!}
            </div>

            <!-- Query Form Text -->
            <div class="form-group">
                {!! Form::label('email', 'Email') !!}
                {!! Form::text('email', Request::input('email'), ['class' => 'form-control search_data', 'data-search_name' => 'email', 'placeholder' => 'Enter something to search...']) !!}
            </div>

            <!-- Query Form Text -->
            <div class="form-group">
                {!! Form::label('firstname', 'First Name') !!}
                {!! Form::text('firstname', Request::input('firstname'), ['class' => 'form-control search_data', 'data-search_name' => 'firstname', 'placeholder' => 'Enter something to search...']) !!}
            </div>

            <!-- Query Form Text -->
            <div class="form-group">
                {!! Form::label('lastname', 'Last Name') !!}
                {!! Form::text('lastname', Request::input('lastname'), ['class' => 'form-control search_data', 'data-search_name' => 'lastname', 'placeholder' => 'Enter something to search...']) !!}
            </div>
        </div>
        <div class="col-sm-6">
            <!-- Query Form Text -->
            <div class="form-group">
                {!! Form::label('company', 'Company') !!}
                {!! Form::text('company', Request::input('company'), ['class' => 'form-control search_data', 'data-search_name' => 'company', 'placeholder' => 'Enter something to search...']) !!}
            </div>
            <!-- Query Form Text -->
            <div class="form-group">
                {!! Form::label('industry', 'Industry') !!}
                {!! Form::text('industry', Request::input('industry'), ['class' => 'form-control search_data', 'data-search_name' => 'industry', 'placeholder' => 'Enter something to search...']) !!}
            </div>
            <!-- Query Form Text -->
            <div class="form-group">
                {!! Form::label('country', 'Country') !!}
                {!! Form::text('country', Request::input('country'), ['class' => 'form-control search_data', 'data-search_name' => 'country', 'placeholder' => 'Enter something to search...']) !!}
            </div>
            <!-- Query Form Text -->
            <div class="form-group">
                {!! Form::label('position', 'Position') !!}
                {!! Form::text('position', Request::input('position'), ['class' => 'form-control search_data', 'data-search_name' => 'position', 'placeholder' => 'Enter something to search...']) !!}
            </div>
        </div>
    </div>

    <!-- Form Submit -->
    <div class="form-group">
        {!! Form::button('Search', ['class' => 'btn btn-primary form-control', 'id' => 'search_button']) !!}
    </div>

    <div id="subscriber_table_container">
        <h1>Subscribers</h1>

        @include('admin.partials.index_page.table_container')
    </div>
@endsection

@push('scripts')
    <script>

        "use strict";

        $(function () {

            $('#search_button').click(function () {

                var search_data             = {};
                search_data['route_path']   = '{{ $route_path }}';
                search_data['current_path'] = '/{{ Request::path() }}';

                $('.search_data').each(function () {

                    search_data[$(this).data('search_name')] = this.value;
                });

                $.post('/admin-search', search_data, function (data) {

                    $('#subscriber_table_container').find('.table_container').html(data);
                });
            });
        });
    </script>
@endpush
