@extends('layouts.admin', ['container' => 'container-fluid'])

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="alert alert-success alert-dismissible fade in" style="display:none">
                <!-- <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a> -->
                <strong>Success!</strong> <span class="message"></span>
            </div>
            <div class="spinner text-center" style="display:none">
                <i class="fa fa-spinner fa-spin"></i>
                <p class="text-primary"></p>
            </div>
        </div>
        <!-- Magazine month Form Select -->
        <!-- <div class="form-group col-md-3">
            {!! Form::select('month', $months ?? [], $filter_month_id ?? NULL, ['id' => 'article_magazine_month_id', 'class' => 'form-control', 'placeholder' => 'Select an Edition...']) !!}
        </div> -->

        <!-- Magazine month Form Select -->
        <!-- <div class="form-group col-md-3">
            {!! Form::select('year', $years ?? [], $filter_year ?? NULL, ['id' => 'mailing_list_year', 'class' => 'form-control', 'placeholder' => 'Select a Year...']) !!}
        </div> -->

        <!-- Magazine printing type Form Select
        <div class="form-group col-md-3">
            {!! Form::select('printing', $printings ?? [], $filter_printing ?? NULL, ['id' => 'mailing_list_printing', 'class' => 'form-control', 'placeholder' => 'Select...']) !!}
        </div>
        -->

        <!-- Magazine mailing list temporary workaround -->
        <!-- <div class="form-group col-md-6">
            {!! Form::button('Create Mailing List Excel Sheet', ['id' => 'create_mailing_list', 'class' => 'btn btn-primary form-control']) !!}
        </div> -->

        <!-- Create Mailing List Table Submit -->
        <!-- <div class="form-group col-md-12">
            {!! Form::button('Create Mailing List Table', ['id' => 'create_mailing_list_table', 'class' => 'btn btn-danger form-control']) !!}
        </div> -->
    </div>

    <!-- <hr/> -->
    <div class="row">
        <div class="col-sm-4">
            <form method="get" class="form-inline form-corporation">
                <div class="form-group">
                    <label for="subscriber_id">Subscriber ID: </label>
                    <input class="form-control" type="number" id="subscriber_id" name="subscriber_id" value="{{ (\Request::has('subscriber_id'))?\Request::get('subscriber_id'):'' }}">
                </div>
            </form>
        </div>
        <div class="col-sm-3 text-right">
            <a href="#" class="btn btn-primary btn-block" id="mailing_list_export">Create Mailing List Excel Sheet</a>
        </div>
        <div class="col-sm-offset-3 col-sm-2 text-right">
            <button type="button" name="button" id="alertbutton" class="btn btn-success btn-block">Save</button>
        </div>
    </div>
    <hr>
    @if (Session::has('warning'))
        <div class="alert alert-warning alert-dismissable">
            <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
            <p>{{ Session::get('warning') }}</p>
        </div>
    @endif

    <div class="mailing-list-section">
        {!! $grid !!}
    </div>
@endsection


@push('scripts')
    <script>

        "use strict";

        var mailing_list_data_table_container  = $('.mailing_list_data_table_container');
        var filter_current_cell_value_check    = '';
        var filter_current_search_option_value = '';

        $(function () {
            $('#alertbutton').click(function() {
                $('.alert-success .message').html('Mailing List was updated successfully!');
                $('.alert-success').fadeIn();
                setTimeout(function(){
                    $('.alert-success').fadeOut();
                },8000)
            });
            $('#article_magazine_month_id').change(function(){
                var article_magazine_month_id = $('#article_magazine_month_id').val();
                var year                      = $('#mailing_list_year').val();

                if (article_magazine_month_id != "" && year != "") {
                    $.post('/subscriber/get_dates', {article_magazine_month_id: article_magazine_month_id, year: year}, function (data) {
                        $('.spinner .text-primary').html('Getting data from '+data+'.');
                    });
                }
            })
            $('#mailing_list_year').change(function(){
                var article_magazine_month_id = $('#article_magazine_month_id').val();
                var year                      = $('#mailing_list_year').val();

                if (article_magazine_month_id != "" && year != "") {
                    $.post('/subscriber/get_dates', {article_magazine_month_id: article_magazine_month_id, year: year}, function (data) {
                        $('.spinner .text-primary').html('Getting data from '+data+'.');
                    });
                }
            })
            $('#mailing_list_export').click(function(){
                var ids = [];
                $('#filter tbody tr').each(function(){
                    ids.push($(this).attr('id'));
                })
                $(this).attr('href',"mailing-list-export?ids="+ids);
            })
            //create a table of the mailing list
            $('#create_mailing_list_table').click(function () {

                var article_magazine_month_id = $('#article_magazine_month_id').val();
                var year                      = $('#mailing_list_year').val();
                var printing                  = $('#mailing_list_printing').val();

                if (article_magazine_month_id == '') {
                    $('#article_magazine_month_id').closest('.form-group').addClass('has-error');
                } else {
                    $('#article_magazine_month_id').closest('.form-group').removeClass('has-error');
                }
                if (year == '') {
                    $('#mailing_list_year').closest('.form-group').addClass('has-error');
                } else {
                    $('#mailing_list_year').closest('.form-group').removeClass('has-error');
                }

                if (article_magazine_month_id != '' && year != '') {
                    $(this).prop('disabled',true);
                    $('.spinner').fadeIn();

                    setTimeout(function(){
                        $('.spinner').fadeOut();
                        $('#create_mailing_list_table').prop('disabled',false);
                        $('.alert-success .message').html('Table was created successfully!');
                        $('.alert-success').fadeIn();
                        setTimeout(function(){
                            $('.alert-success').fadeOut();
                        },8000)
                    },50000)

                    $.post('/subscriber/create_mailing_list_table', {article_magazine_month_id: article_magazine_month_id, year: year, printing:printing}, function (data) {
                        if (data === 'FALSE') {
                            $('.spinner').fadeOut();
                            $('#create_mailing_list_table').prop('disabled',false);
                            alert('Table already exists.');
                        }
                    });
                }
            });

            //create the mailing list
            $('#create_mailing_list').click(function () {

                var article_magazine_month_id = $('#article_magazine_month_id').val();
                var year                      = $('#mailing_list_year').val();
                var printing                  = $('#mailing_list_printing').val();

                if (article_magazine_month_id == '') {
                    $('#article_magazine_month_id').closest('.form-group').addClass('has-error');
                } else {
                    $('#article_magazine_month_id').closest('.form-group').removeClass('has-error');
                }
                if (year == '') {
                    $('#mailing_list_year').closest('.form-group').addClass('has-error');
                } else {
                    $('#mailing_list_year').closest('.form-group').removeClass('has-error');
                }

                if (article_magazine_month_id != '' && year != '') {
                    $(this).prop('disabled',true);
                    $('.spinner').fadeIn();

                    $.post('/subscriber/create_mailing_list', {month: article_magazine_month_id, year: year, printing:printing}, function (data) {
                        if (data === 'FALSE') {
                            $('.spinner').fadeOut();
                            $('#create_mailing_list').prop('disabled',false);
                            alert('Table does not exists. Please, create mailing list table first.');
                        } else {
                            setTimeout(function(){
                                $('.spinner').fadeOut();
                                $('#create_mailing_list').prop('disabled',false);
                                $('.alert-success .message').html('Mailing List was sent successfully!');
                                $('.alert-success').fadeIn();
                                setTimeout(function(){
                                    $('.alert-success').fadeOut();
                                },8000)
                            },10000)
                        }
                    });
                }
            });

            $('.set_region').change(function () {

                var subscriber_id = $(this).data('subscriber_id');

                if (this.value === '840') {
                    set_mailing_list_region_question(subscriber_id, 'states')
                } else {
                    set_mailing_list_region_question(subscriber_id, 'region_text')
                }
            });

            function update_magazine(el) {
                var parent = $(el).closest('.column-magazine');

                var subscriber_id = $(el).data('subscriber_id'),
                magazine = $(el).data('subscription_value');

                $.post('/subscriber/update_magazine', {subscriber_id: subscriber_id, magazine: magazine}, function (data) {
                    if (data) {
                        parent.append(data);
                        $(el).remove();
                    } else {
                        console.log(0);
                    }
                });
            }

            $('.subscriber_update').change(function () {

                var params        = {};
                var subscriber_id = $(this).data('subscriber_id');

                params[$(this).attr('name')] = this.value;

                update_subscriber(subscriber_id, params);
            });
        });

        function set_mailing_list_region_question(subscriber_id, type) {

            $.get('/subscriber/set_mailing_list_region_question/' + type, {subscriber_id: subscriber_id}, function (data) {

                $('#' + subscriber_id + ' .region_container').html(data);
            });
        }

        function update_subscriber(subscriber_id, params) {

            $.ajax({
                url    : '/subscriber/' + subscriber_id,
                type   : 'PATCH',
                data   : params,
                success: function (data) {
                    $('#data').html(data);
                }
            });
        }

        function update_magazine(el) {
            var parent = $(el).closest('.column-magazine');

            var subscriber_id = $(el).data('subscriber_id'),
            magazine = $(el).data('subscription_value');

            $.post('/subscriber/update_magazine', {subscriber_id: subscriber_id, magazine: magazine}, function (data) {
                if (data) {
                    parent.append(data);
                    $(el).remove();
                } else {
                    console.log(0);
                }
            });
        }
    </script>
@endpush
