@extends('layouts.admin', ['container' => 'container-fluid'])

@section('content')
    <div class="row">
        <!-- Magazine month Form Select -->
        <div class="form-group col-md-4">
            {!! Form::select('month', $months ?? [], $filter_month_id ?? NULL, ['id' => 'article_magazine_month_id', 'class' => 'form-control', 'placeholder' => 'Select an Edition...']) !!}
        </div>

        <!-- Magazine month Form Select -->
        <div class="form-group col-md-4">
            {!! Form::select('year', $years ?? [], $filter_year ?? NULL, ['id' => 'mailing_list_year', 'class' => 'form-control', 'placeholder' => 'Select a Year...']) !!}
        </div>

        <!-- Magazine month Form Select -->
        <div class="form-group col-md-4">
            <!-- Form Submit -->
            {!! Form::button('Create Mailing List Excel Sheet', ['id' => 'create_mailing_list', 'class' => 'btn btn-primary form-control']) !!}
        </div>

        <!-- Create Mailing List Table Submit -->
        <div class="form-group col-md-12">
            {!! Form::button('Create Mailing List Table', ['id' => 'create_mailing_list_table', 'class' => 'btn btn-danger form-control']) !!}
        </div>
    </div>

    <hr/>
    <div class="row">
        <div class="col-md-12">
            <h1 id="filter_total"></h1>
        </div>
    </div>

    <div class="row">
        <!-- Filters Form Select -->
        <div class="form-group col-md-12">
            {!! Form::select('filters', $filters ?? [], $filter ?? NULL, ['id' => 'filter_search_option', 'class' => 'form-control', 'placeholder' => 'Select a Filter...']) !!}
        </div>
    </div>

    @if(isset($subscribers))
        <div class="table-responsive">
            <table class="table table-striped">
                <thead>
                <tr>
                    <th></th>
                    <th>Company Name</th>
                    <th>First Name</th>
                    <th>Last Name</th>
                    <th>Address 1</th>
                    <th>Address 2</th>
                    <th>City</th>
                    <th>Postal Code</th>
                    <th>Region</th>
                    <th>Country</th>
                </tr>
                </thead>
                <tbody>
                @foreach($subscribers as $subscriber)
                    <tr id="{{ $subscriber->id }}" data-toggle="tooltip" title="{{ $subscriber->email }}">
                        <td>
                            @include('admin.subscribers.partials.subscription_button', ['subscription_name' => 'magazine', 'subscription_status' => $subscriber->magazine, 'subscriber_id' => $subscriber->id])
                        </td>
                        <td width="300" class="{{ strlen($subscriber->company) > 40 ? 'danger' : '' }}">
                            <div class="input-group">
                                {!! Form::text('company', $subscriber->company, ['class' => 'subscriber_update form-control', 'data-subscriber_id' => $subscriber->id]) !!}
                                <span class="input-group-btn">
                                    <a class="btn btn-default" target="_blank" href="https://www.google.com/search?q={{ urlencode($subscriber->company) }}">></a>
                                </span>
                            </div>
                        </td>
                        <td>
                            {!! Form::text('firstname', $subscriber->firstname, ['class' => 'subscriber_update form-control', 'data-subscriber_id' => $subscriber->id]) !!}
                        </td>
                        <td>
                            {!! Form::text('lastname', $subscriber->lastname, ['class' => 'subscriber_update form-control', 'data-subscriber_id' => $subscriber->id]) !!}
                        </td>
                        <td width="300" class="{{ strlen($subscriber->address_1) > 40 ? 'danger' : '' }}">
                            <div class="input-group">
                                {!! Form::text('address_1', $subscriber->address_1, ['class' => 'subscriber_update form-control', 'data-subscriber_id' => $subscriber->id]) !!}
                                <span class="input-group-btn">
                                    <a class="btn btn-default" target="_blank" href="https://www.google.com/search?q={{ urlencode($subscriber->address_1) }}">></a>
                                </span>
                            </div>
                        </td>
                        <td width="300" class="{{ strlen($subscriber->address_2) > 40 ? 'danger' : '' }}">
                            {!! Form::text('address_2', $subscriber->address_2, ['class' => 'subscriber_update form-control', 'data-subscriber_id' => $subscriber->id]) !!}
                        </td>
                        <td class="{{ strlen($subscriber->city) > 40 ? 'danger' : '' }}">
                            {!! Form::text('city', $subscriber->city, ['class' => 'subscriber_update form-control', 'data-subscriber_id' => $subscriber->id]) !!}
                        </td>
                        <td width="120">
                            {!! Form::text('postal_code', $subscriber->postal_code, ['class' => 'subscriber_update form-control', 'data-subscriber_id' => $subscriber->id]) !!}
                        </td>
                        <td class="region_container">
                            @if($subscriber->subscriber_region_id || $subscriber->country_id === 840)
                                @include('admin.subscribers.mailing_list.partials.states')
                            @else
                                @include('admin.subscribers.mailing_list.partials.region_text')
                            @endif
                        </td>
                        <td width="125">
                            {!! Form::select('country_id', $countries ?? [], $subscriber->country_id, ['class' => 'subscriber_update set_region form-control', 'data-subscriber_id' => $subscriber->id, 'placeholder' => 'Countries']) !!}
                        </td>
                        <!-- Email Form Hidden -->
                        {!! Form::hidden('email', $subscriber->email, ['id' => $subscriber->id . '_email']) !!}
                    </tr>
                @endforeach
                </tbody>
            </table>
            @include('admin.partials.index_page.pagination_links', ['collection' => $subscribers])
        </div>
    @endif
@endsection


@push('scripts')
    <script>

        "use strict";

        var mailing_list_data_table_container  = $('.mailing_list_data_table_container');
        var filter_current_cell_value_check    = '';
        var filter_current_search_option_value = '';

        $(function () {

            //create a table of the mailing list
            $('#create_mailing_list_table').click(function () {

                var article_magazine_month_id = $('#article_magazine_month_id').val();
                var year                      = $('#mailing_list_year').val();

                $.post('/subscriber/create_mailing_list_table', {article_magazine_month_id: article_magazine_month_id, year: year}, function (data) {

                    if (data === 'FALSE')
                        alert('Table already exists.');
                });
            });

            //create the mailing list
            $('#create_mailing_list').click(function () {

                var article_magazine_month_id = $('#article_magazine_month_id').val();
                var year                      = $('#mailing_list_year').val();

                $.post('/subscriber/create_mailing_list', {article_magazine_month_id: article_magazine_month_id, year: year});
            });

            mailing_list_data_table_container.on('.subscriber_update', 'focusin', function () {

                filter_current_cell_value_check = this.value;
            });

            $('.set_region').change(function () {

                var subscriber_id = $(this).data('subscriber_id');

                if (this.value === '840') {

                    set_mailing_list_region_question(subscriber_id, 'states')
                } else {

                    set_mailing_list_region_question(subscriber_id, 'region_text')
                }
            });

            $('.subscriptions').click(function () {

                if (this.value === filter_current_cell_value_check) return false;

                var params        = {};
                var subscriber_id = $(this).data('subscriber_id');

                params['magazine'] = $(this).data('subscription_value');
                params['email']    = $('#' + subscriber_id + '_email').val();

                $('#' + subscriber_id).remove();

                update_subscriber(subscriber_id, params);
            });

            $('.subscriber_update').focusout(function () {

                if (this.value === filter_current_cell_value_check) return false;

                var params        = {};
                var subscriber_id = $(this).data('subscriber_id');

                params[$(this).attr('name')] = this.value;
                params['email']              = $('#' + subscriber_id + '_email').val();

                update_subscriber(subscriber_id, params);
            });

            $('.subscriber_update').change(function () {

                if (this.value === filter_current_cell_value_check) return false;

                var params        = {};
                var subscriber_id = $(this).data('subscriber_id');

                params[$(this).attr('name')] = this.value;
                params['email']              = $('#' + subscriber_id + '_email').val();

                update_subscriber(subscriber_id, params);
            });

            $('#filter_search_option').change(function () {

                filter_current_search_option_value = this.value;

                filter_subscriber(filter_current_search_option_value);
            });
        });

        //retrieve the filtered data for the subscribers
        function filter_subscriber(filter) {

            var filter_month_id = $('#article_magazine_month_id').val();
            var filter_year     = $('#mailing_list_year').val();

            window.location.href = '/subscriber/mailing-list?filter=' + filter + '&filter_month_id=' + filter_month_id + '&filter_year=' + filter_year;
        }

        function set_mailing_list_region_question(subscriber_id, type) {

            $.get('/subscriber/set_mailing_list_region_question/' + type, {subscriber_id: subscriber_id}, function (data) {

                $('#' + subscriber_id + ' .region_container').html(data);
            });
        }

        function update_subscriber(subscriber_id, params) {

            $.ajax({
                       url    : '/subscriber/' + subscriber_id,
                       type   : 'PATCH',
                       data   : params,
                       success: function (data) {
                           $('#data').html(data);
                       }
                   });
        }
    </script>
@endpush
