<style>
    #magazine_subscription_information_container {
        display: none;
    }
</style>

<div id="magazine_subscription_information_container">

    <h1>Magazine Questions</h1>
    <div class="alert alert-info" role="alert">To get the magazine subscription please complete the below section.</div>

    <!-- Country Form Select -->
    <div class="form-group has-feedback {{ (!empty(old('country_id')) && !$errors->has('country_id')) || (isset($subscriber) && !empty($subscriber->country_id)) ? 'has-success' : 'has-error' }}">
        {!! Form::label('country_id', 'Country*') !!}
        {!! Form::select('country_id', isset($countries) ? $countries : [], NULL, ['id' => 'country', 'class' => 'form-control subscriber_data magazine_subscription_information', 'placeholder' => 'Please choose']) !!}
        <span class="glyphicon glyphicon-remove form-control-feedback"></span>
    </div>

    <!-- phone Form Text -->
    <div class="form-group">
        {!! Form::label('phone', 'Phone') !!}
        {!! Form::text('phone', NULL, ['class' => 'form-control subscriber_data']) !!}
    </div>

    <!-- address_1 Form Text -->
    <div class="form-group has-feedback {{ (!empty(old('address_1')) && !$errors->has('address_1')) || (isset($subscriber) && !empty($subscriber->address_1)) ? 'has-success' : 'has-error' }}">
        {!! Form::label('address_1', 'Address 1*') !!}
        {!! Form::text('address_1', NULL, ['class' => 'form-control subscriber_data magazine_subscription_information']) !!}
        <span class="glyphicon glyphicon-remove form-control-feedback"></span>
    </div>

    <!-- Address 2 Form Text -->
    <div class="form-group">
        {!! Form::label('address_2', 'Address 2') !!}
        {!! Form::text('address_2', NULL, ['class' => 'form-control subscriber_data']) !!}
    </div>

    <!-- city Form Text -->
    <div class="form-group has-feedback {{ (!empty(old('city')) && !$errors->has('city')) || (isset($subscriber) && !empty($subscriber->city)) ? 'has-success' : 'has-error' }}">
        {!! Form::label('city', 'City*') !!}
        {!! Form::text('city', NULL, ['class' => 'form-control subscriber_data magazine_subscription_information']) !!}
        <span class="glyphicon glyphicon-remove form-control-feedback"></span>
    </div>

    <div id="region_container">
        <!-- 840 - United States -->
        @if((isset($subscriber) && $subscriber->country_id === 840) || old('country_id') === '840')
            @include('admin.subscribers.partials.region_united_states_drop_down')
        @else
            @include('admin.subscribers.partials.region_text')
        @endif
    </div>
</div>

@push('scripts')
    <script>

        "use strict";

        $(function () {

            $('#country').chosen({width: "100%"}).change(function () {

                if (this.value === '840') {

                    $.get('/subscriber/set_region_question/region_united_states_drop_down', {}, function (data) {

                        $('#region_container').html(data);

                        $('#region_container').on('change', '.magazine_subscription_information', function () {

                            check_validation($(this), this.value);
                        });
                    });
                } else {

                    $.get('/subscriber/set_region_question/region_text', {}, function (data) {

                        $('#region_container').html(data);

                        $('#region_container').on('keyup', '.magazine_subscription_information', function () {

                            check_validation($(this), this.value);
                        });
                    });
                }
            });

            //sets the validation for each field after the page has loaded.
            $('.magazine_subscription_information').each(function () {

                //default value is already set to error only needed if field is filled.
                if (this.value !== '')
                    check_validation($(this), this.value);
            });

            /**
             *
             * Magazine Information Validation Check Actions keyup, change
             *
             */
            $('.magazine_subscription_information').keyup( function () {

                check_validation($(this), this.value);
            });

            $('.magazine_subscription_information').change( function () {

                check_validation($(this), this.value);
            });
        });

        function check_validation(curr_obj, value) {

            if (value !== '') {

                curr_obj.parent('div').removeClass('has-error').addClass('has-success');
                curr_obj.siblings('span').removeClass('glyphicon-remove').addClass('glyphicon-ok')
            } else {

                curr_obj.parent('div').removeClass('has-success').addClass('has-error');
                curr_obj.siblings('span').removeClass('glyphicon-ok').addClass('glyphicon-remove')
            }
        }
    </script>
@endpush
