@if(isset($subscriptions))
    <div class="form-group row">
        @foreach($subscriptions as $subscription)
            <div style="padding-bottom: 15px;" class="subscription_button_div col-md-{{ 12/count($subscriptions) }}">
                <button class="subscription_button btn btn-primary btn-block" data-type="{{ $subscription['name'] }}">
                    <i class="fa fa-pull-left fa-2x {{ ((isset($subscriber) && $subscriber->{$subscription['name']} == '1') || ($subscription['status'] == '1' && !isset($subscriber)) ? 'fa-check text-success' : 'fa-times text-danger') }}">
                    </i>
                    {{ $subscription['title'] }}
                </button>
                <input type="hidden" id="{{ $subscription['name'] }}_hidden_subscription" name="{{ $subscription['name'] }}" class="subscriptions subscriber_data" value="{{ (isset($subscriber) ? $subscriber->{$subscription['name']} : $subscription['status']) }}">
            </div>
        @endforeach
    </div>

    @push('scripts')
        <script>

            "use strict";

            var magazine_subscription_information_container = $('#magazine_subscription_information_container');

            $(function () {

                if (magazine_subscription_information_container.length > 0 && $('#magazine_hidden_subscription').val() !== '0') {

                    magazine_subscription_information_container.slideDown();
                }

                $('.subscription_button').click(function (e) {

                    //stop button from submitting form
                    e.preventDefault();

                    //stop the bar from dropping down if it exists
                    if (typeof stop_bizzbar === 'function') {

                        stop_bizzbar();
                    }

                    //get the type of subscription
                    var subscription_type = $(this).data('type');

                    //toggle the subscription visual que
                    $('i', this).toggleClass('fa-times text-danger').toggleClass('fa-check text-success');

                    //toggle the hidden field value
                    var hidden_subscription_obj = $('#' + subscription_type + '_hidden_subscription');
                    hidden_subscription_obj.val((hidden_subscription_obj.val() === '0' ? '1' : '0'));

                    //container that has the magazine questions FOR FRONTEND USE ONLY
                    if (magazine_subscription_information_container.length > 0 && subscription_type === 'magazine' && hidden_subscription_obj.val() !== '0') {

                        magazine_subscription_information_container.slideDown();
                    } else if (magazine_subscription_information_container.length > 0 && subscription_type === 'magazine') {

                        magazine_subscription_information_container.slideUp();
                    }
                });
            });
        </script>
    @endpush
@endif
