<th>Subscriber ID</th>
<th>Created</th>
<th>Email</th>
<th>First Name</th>
<th>Last Name</th>
<th>Magazine</th>
<th>Digital</th>
<th>Newsletter</th>
<th>Email Marketing</th>

@push('scripts')
    <script>
        "use strict";

        $(function () {

            $('.table_container').on('click', '.subscriptions', function () {

                console.log('Subscription Clicked');
                console.log($(this).data());

                var curr_obj           = $(this);
                var subscription       = curr_obj.data('subscription');
                var subscriber_id      = curr_obj.data('subscriber_id');
                var subscription_value = curr_obj.data('subscription_value');

                // Added to allow magazine to redirect to the subscription form because address is required.
                // Magazine unsubscribes will bypass this.
                if (subscription === 'magazine' && subscription_value) {

                    window.location.href = '/subscriber/' + subscriber_id + '/edit';

                    return false;
                }

                $.post('/subscriber/update_subscription', $(this).data(), function (data) {

                    console.log(data);

                    if (data === '1') {

                        curr_obj.removeClass('btn-success').addClass('btn-danger');
                        curr_obj.data('subscription_value', '');
                        curr_obj.data('status', 'unsubscribe');
                        curr_obj.val('Unsubscribe');
                    } else {

                        curr_obj.removeClass('btn-danger').addClass('btn-success');
                        curr_obj.data('subscription_value', '1');
                        curr_obj.data('status', 'subscribe');
                        curr_obj.val('Subscribe');
                    }
                });
            });
        });
    </script>
@endpush()