@extends('layouts.site')

@push('meta')
    <title>About Us - The Maritime Executive</title>
    <meta name="description" content="The Maritime Executive is the world’s largest maritime media platform covering the latest maritime news and analysis both online and in print. ">
    <meta name="keywords" content="">
    <meta property="og:title" content="About Us - The Maritime Executive">
    <meta property="og:url" content="https://maritime-executive.com/aboutus">
    <meta property="og:description" content="The Maritime Executive is the world’s largest maritime media platform covering the latest maritime news and analysis both online and in print. ">
@endpush

@section('content')
    <section class="wrap-content">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
				<h4 class="bl-6 b-color-4 col-md-6 text-uppercase">
                        <span class="bold red">The Maritime Executive</span> About Us
                    </h4>
                  <div class="clearfix"></div>
                    
                    <img src="/media/images/site/aboutus/mags.png" class="img-responsive pull-right" alt="">
                    <h2>History</h2>
                    <p>Founded in 1997 and modeled on the “case study” approach of the Harvard Business Review, The Maritime Executive today has the largest AUDITED circulation in the maritime industry. Its unique perspective and unfettered approach give readers something no other publication can provide – Intellectual Capital of the highest order. Published six times a year, each issue contains a comprehensive Case Study and Executive Interview along with in-depth analyses of key industry issues and trends. 
                    </p>
                    <p>The companion online newsletter, published six days a week, is the industry leader with a high-profile audience and critical news and intelligence from around the world. 
                    </p>
                    <p>The MarEx website, launched in 1999, is a widely recognized source of up-to-date maritime news and information including editorial commentary, featured articles, podcasts, blogs, a jobs board and access to previous editions of the magazine. 
                    </p>
                    <p>Through our various print and digital platforms, we continue to innovate and expand to provide readers and advertisers alike the largest maritime media outlet available today. 
                    </p>
                    <h2>Mission</h2>
                    <p>To provide business leaders, professionals and executives with high-quality, incisive commentary on critical maritime issues. Our media platforms are not only a source of Intellectual Capital but also create enormous value for advertisers. Our goal is to be the top media venue for readers and advertisers.
                    </p>
                    <h2>Vision</h2>
                    <p>To be the most recognized name in maritime media and the leading source of maritime news and information. We achieve this through quality editorial, elegant design and continuing investment in online technologies to reach the widest possible global audience.
                    </p>
                </div>
            </div>
        </div>
    </section>
@endsection