@extends('layouts.site')

@push('meta')
<title>{{ $article->title }}</title>
<meta name="getsocial" content="{{ $article->published_at > '2018-01-18 11:00:00' ? '1' : '0'}}">
<meta name="description" content="{{ $article->meta_description }}">
<meta name="keywords" content="{{ $article->meta_keywords }}">
<meta property="fb:app_id" content="1469304603284925">
<meta property="og:site_name" content="The Maritime Executive">
<meta property="og:title" content="{{ $article->title }}" />
<meta property="og:url" content="{{ $article->link }}" />
<meta property="og:description" content="{{ $article->meta_description }}" />
<meta property="og:image" content="{{ isset($article->article_image) ? $article->article_image->link : ''}}" />
<meta property="og:type" content="article" />
@endpush

@section('content')
<div class="article-node-wrapper">
    <section class="wrap-content article-node-content pt-15">
        <div class="container">
            <div class="row">
                <div class="main-content col-lg-6 col-md-5 col-sm-8 col-lg-push-3 col-md-push-3">
                    <div class="custom_social_setting">
                        @isset($preview)
                        @if($preview)
                        <div style="font-size: 24pt; color: lightgray; text-align: center;" class="preview">Article Preview</div>
                        @endif
                        @endisset
                        <div class="ga-views">
                            <div class="ga-views-count text-center bold">
                                {{ $pageviews }}
                            </div>
                            <div class="text-center views-title">
                                Views
                            </div>
                        </div>
						@include('site.partials.get_social.social-icons', ['show_title' => false])
                        @include('site.partials.get_social.horizontal_share_bar')
                    </div>
                    <article class="feature-item article-node pt-15">
                        <h1 class="color-black bold article-title title">
                            @foreach($article->articleTitleTags AS $tag)
                            {{ $tag->name }}
                            @endforeach
                            {!! $article->title !!}
                        </h1>
                        <h3>{{ $article->sub_title }}</h3>
                        <figure class="image">
                            @if($article->script_image)
                            {!! $article->script_image->source !!}
                            <figcaption>{{ $article->script_image->caption }}</figcaption>
                            @elseif($article->article_image)
                            @include('site.partials.site.image', ['image' => $article->article_image])
                            <figcaption>{{ $article->article_image->caption }}</figcaption>
                            @endif
							 @include('site.partials.article.author_date_time', ['article' => $article, 'date' => TRUE])
                        </figure>

                        @include('site.partials.get_social.reaction_buttons')

                       

                        @if(isset($article->articleType) && $article->articleType->slug === 'magazine' && isset($article->articleMagazineEdition) && $article->articleMagazineEdition)
                        <p>
                            <span style="font-size:11px;">
                                <em>
                                    <strong>
                                        (Article originally published in {{ $article->articleMagazineEdition->articleMagazineMonth->name }} {{ $article->articleMagazineEdition->year }} edition.)
                                    </strong>
                                </em>
                            </span>
                        </p>
                        @endif

                        @if(isset($article->articleType) && $article->articleType->slug === 'job')
                        <div class="row" style="margin-bottom: 30px;">
                            <div class="col-md-6">
                                <table border="0" cellpadding="1" cellspacing="1" style="width:300px">
                                    <tbody>
                                        @if(!empty($article->job_sector))
                                        <tr>
                                            <td><strong>Sector</strong></td>
                                            <td>{{ $article->job_sector  }}</td>
                                        </tr>
                                        @endif
                                        @if(!empty($article->job_application_closing_date))
                                        <tr>
                                            <td><strong>Application Closing Date</strong></td>
                                            <td>{{ $article->job_application_closing_date  }}</td>
                                        </tr>
                                        @endif
                                        @if(!empty($article->job_manages_others))
                                        <tr>
                                            <td><strong>Manages Others</strong></td>
                                            <td>{{ $article->job_manages_others  }}</td>
                                        </tr>
                                        @endif
                                        @if(!empty($article->job_experience_required))
                                        <tr>
                                            <td><strong>Experience required</strong></td>
                                            <td>{{ $article->job_experience_required  }}</td>
                                        </tr>
                                        @endif
                                        @if(!empty($article->job_employment_type))
                                        <tr>
                                            <td><strong>Employment Type</strong></td>
                                            <td>{{ $article->job_employment_type  }}</td>
                                        </tr>
                                        @endif
                                        @if(!empty($article->job_work_schedule))
                                        <tr>
                                            <td><strong>Work Schedule</strong></td>
                                            <td>{{ $article->job_work_schedule  }}</td>
                                        </tr>
                                        @endif
                                    </tbody>
                                </table>
                            </div>

                            <div class="col-md-6">
                                <a class="btn btn-block btn-lg btn-info" href="{{ $article->job_link }}" role="button" target="_blank">APPLY</a>
                            </div>
                        </div>
                        @endif

                        {!! $article->content !!}

                        @if(isset($article->articleType) && $article->articleType->slug === 'corporate')
                        <p style="font-size: 12px;">The products and services herein described in this press release are not endorsed by The Maritime Executive.</p>
                        @elseif(isset($article->articleType) && $article->articleType->slug !== 'article' && $article->articleType->slug !== 'job')
                        <p style="font-size: 12px;">The opinions expressed herein are the author's and not necessarily those of The Maritime Executive.</p>
                        @endif
                        <div class="clearfix"></div>

                    </article>
                </div>
				
                <div class="primary col-lg-3 col-md-3 hidden-sm col-lg-pull-6 col-md-pull-5">
                    @if (isset($top_stories))
                    <div class="more-top-stories" id="more-top-stories-container">
				<div class="header font-firasans">
                                    <span class="title bl-6 b-color-4">
                                        <strong>MORE</strong> TOP STORIES
                                    </span>
                                </div>
                       
                        @include('site.partials.article.stories-list', [
                        'articles' => $more_top_stories,
                        ])
                    </div>
                    @endif
                    @if (isset($top_stories))
                    <!--div class="editorials pt-15" id="editorials-container"-->
                    <div class="more-top-stories" id="more-top-stories-container">
                       
						<div class="header font-firasans">
                                    <span class="title bl-6 b-color-4">
                                        <strong>EDITORIALS</strong> TOP STORIES
                                    </span>
                                </div>
								{{--@include('site.partials.article.simple-node-list', [
                        'articles' => $editorials,
                        'listClass' => 'list-inline p-0',
                        'listItemClass' => 'bold pb-5',
								])--}}
						 @include('site.partials.article.stories-list', [
                        'articles' => $editorials,
                        ])
                    </div>
                    @endif
                </div>
                @include('site.partials.site.right_side_column', ['side_article_content' => $side_article_content])
            </div>

            <div class="hidden-xs">
                @include('site.partials.ads.subscribe_now')
            </div>

            <div class="clearfix container l2-ads-wrapper">
                @include('site.partials.ads.625x50_1')
            </div>

            <div class="related-stories-wrapper container mt-2">
                <div class="col-md-1"></div>
                <div class="col-md-10 col-sm-12">
                    <div class="tertiary-articles">
                        
						 
						<div class="header font-firasans">
                                    <span class="title bl-6 b-color-4">
                                        <strong>RELATED</strong> STORIES
                                    </span>
                                </div>
						 <div class="secondary-articles secondary-articles2">
						 @include('site.partials.article.related-stories-new', [
                        'articles' => $related_stories,
                        'grid_class' => 'col-lg-3 col-md-3 col-sm-3 col-xs-6 pl-0-xs',
                        'category_class' => 'bg-1'
                        ])
						</div>
						 <!--div class="secondary-articles secondary-articles2">
						 {{--@include('site.partials.article.teaser-grid-category', [
                        'articles' => $categoriesupper,
                        'grid_class' => 'col-lg-4 col-md-4 col-sm-4 col-xs-12',
                        'category_class' => 'bg-1'
						 ])--}}
						</div-->
						{{--
                        @include('site.partials.article.teaser-grid', [
                        'articles' => $related_stories,
                        'grid_class' => 'col-lg-3 col-md-3 col-sm-3 col-xs-6 pl-0-xs',
                        'category_title_class' => 'color-1'
                        ])
						--}}
                    </div>
                </div>
                <div class="col-md-1"></div>
            </div>

            <div class="hidden-lg hidden-md hidden-sm">
                @include('site.partials.ads.subscribe_now')
            </div>

            <div class="comments-wrapper mt-2 container">
                <div class="col-md-2 col-sm-1"></div>
                <div class="col-md-8 col-sm-10">
                    <div class="article-comments">
                        @if(isset($article->articleType) && $article->articleType->slug !== 'job')
                        @include('site.partials.site.disqus')
                        @endif
                    </div>
                </div>
                <div class="col-md-2 col-sm-1"></div>
            </div>

        </div>
    </section>
</div>
@endsection