@extends('layouts.site')

@push('meta')
    <title>{{ $category->meta_title }}</title>
    <meta name="description" content="{{ $category->meta_description }}">
    <meta name="keywords" content="{{ $category->meta_keywords }}">
    <meta property="og:title" content="{{ $category->meta_title ?? $category->title }}">
    <meta property="og:url" content="{{ $category->link }}">
    <meta property="og:description" content="{{ $category->meta_description }}">
@endpush

@section('content')
    <section class="wrap-content list-article">
        <div class="container">
            <div class="row">
                <div class="main-content col-md-8 col-sm-8">
					<h4 class="bl-6 b-color-4 col-md-6 text-uppercase">
                        <span class="bold">{{ $category->title }}</span> News
                    </h4>
                  <div class="clearfix"></div>

                    @include('site.partials.article.more_articles_content', ['articles' => $main_articles])

                    <div class="clearfix"></div>

                    @include('site.partials.article.more_articles_button', ['article_content_box_id' => 'article_container', 'slug' => $category->slug, 'path' => $category->slug, 'limit' => 4, 'offset' => 10])

                    <div class="clearfix"></div>

                    @include('site.partials.ads.625x50_1')

                </div>

                @include('site.partials.site.right_side_column', ['side_article_content' => $side_article_content])

            </div>
        </div>
    </section>
@endsection()