@extends('layouts.site')

@push('meta')
    <title>{{ $author->title }}</title>
    <meta name="description" content="{{ $author->bio }}">
    <meta name="keywords" content="">
    <meta property="og:title" content="{{ $author->title }}">
    <meta property="og:url" content="{{ $author->link }}">
    <meta property="og:description" content="{{ $author->bio }}">
@endpush

@section('content')
    <section class="wrap-content list-article">
        <div class="container">
            <div class="row">
                <div class="main-content col-md-8 col-sm-8">
					 <h4 class="bl-6 b-color-4 col-md-6 text-uppercase">
						<span class="bold">{{ $author->full_name }}</span>
					</h4>
                    <h2><span class="marexsub">{{ $author->title }}</span></h2>

                    <div class="col-md-12" style="padding-bottom: 30px;">
                        <div class="col-md-4">
                            @include('site.partials.site.image', ['image' => $author->articleAuthorImages->first()])
                        </div>
                        <div class="col-med-8">
                            <p>
                                <a href="mailto:{{ $author->email }}">{{ $author->email }}</a>
                            </p>
                            <p>
                                {!! $author->bio !!}
                            </p>
                        </div>
                    </div>

                    <div class="clearfix"></div>

                    @include('site.partials.article.more_article_content_new', ['articles' => $main_articles])
					
					

                    <div class="clearfix"></div>

                    @include('site.partials.article.more_articles_button', ['limit' => 4, 'offset' => 8, 'path' => 'author/' . $author->slug, 'article_content_box_id' => 'article_container'])

                    <div class="clearfix"></div>

                    @include('site.partials.ads.625x50_1')

                </div>

                @include('site.partials.site.right_side_column', ['side_article_content' => $side_article_content])

            </div>
        </div>
    </section>
@endsection()