@extends('layouts.site')

@push('meta')
    <title>Blog Articles- The Maritime Executive</title>
    <meta name="description" content="Delivering the most up-to-the-minute news, opinions and insight in maritime training, finance and law.">
    <meta name="keywords" content="">
    <meta property="og:title" content="Blog Articles - The Maritime Executive">
    <meta property="og:url" content="https://maritime-executive.com/blog">
    <meta property="og:description" content="Delivering the most up-to-the-minute news, opinions and insight in maritime training, finance and law.">
@endpush

@section('content')
    <section class="wrap-content list-article">
        <div class="container">
            <div class="row">
                <div class="main-content col-md-8 col-sm-8">

                  
					<div class="header font-firasans text-uppercase   ">
                                    <span class="title bl-6 b-color-4">
                                        <strong>Blogs</strong>
                                    </span>
                                </div>

                    @include('site.partials.article.more_articles_content', ['articles' => $blog_articles])

                    <div class="clearfix"></div>

                    @include('site.partials.article.more_articles_button', ['slug' => $blog_slug ?? '', 'path' => $blog_path ?? '', 'limit' => 4, 'offset' => 10, 'article_content_box_id' => 'article_container'])

                    <div class="clearfix"></div>

                    
                </div>

                <div class="sidebar magsidebar text-center col-md-4 col-sm-4">
                    @include('site.partials.ads.300x250_1')
                    @include('site.partials.ads.300x250_2')

                    @include('site.partials.ads.300x250_3')
                    @include('site.partials.ads.300x250_4')

                    <div class="adds">
						<h4 class=" text-uppercase ">
                        <span class="bl-6 b-color-4 bold">Blogs</span> by category
						</h4>
                        <div class="graybox" align="center">
                            <div class="topStoryTab">
                               
                            </div>
                            <div id="blog-fin" class="story blog-box">
                                <a href="/blog-finance">
                                    <figure>
                                        <p>Maritime Finance</p>
                                    </figure>
                                </a>
                            </div>
                            <div id="blog-rec" class="story blog-box">
                                <a href="/blog-recruitment">
                                    <figure>
                                        <p>Maritime Recruitment</p>
                                    </figure>
                                </a>
                            </div>
                            <div id="blog-law" class="story blog-box">
                                <a href="/blog-law">
                                    <figure>
                                        <p>Maritime Law</p>
                                    </figure>
                                </a>
                            </div>
                            <div id="blog-ed" class="story blog-box">
                                <a href="/blog-training">
                                    <figure>
                                        <p>Maritime Training</p>
                                    </figure>
                                </a>
                            </div>
                            <div id="blog-tech" class="story blog-box">
                                <a href="/blog-technology">
                                    <figure>
                                        <p>Maritime Technology</p>
                                    </figure>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
			@include('site.partials.ads.625x50_1')
        </div>
    </section>
@endsection()
