@extends('layouts.site')

@push('meta')
    <title>Contact Us - The Maritime Executive</title>
    <meta name="description" content="Have a question or comment you want to share with The Maritime Executive? Please contact us today!">
    <meta name="keywords" content="">
    <meta property="og:title" content="Contact Us - The Maritime Executive">
    <meta property="og:url" content="https://maritime-executive.com/contact">
    <meta property="og:description" content="Have a question or comment you want to share with The Maritime Executive? Please contact us today!">
@endpush

@section('content')
    <section class="wrap-content">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                  
					<h4 class="bl-6 b-color-4 col-md-6 text-uppercase">
                        <span class="bold red">MarEx</span> ContactUs
                    </h4>
					<div class="clearfix"></div>
                    <div class="row">
                        <div class="col-md-4">
                            {!! Form::open(['action' => 'ContactController@sendEmail', 'id' => 'contact_form']) !!}
                            <div class="form-group">
                                <label>Select Department*</label>
                                <select class="form-control" name="type">
                                    {{-- todo-hammy v2 add in option to Update Subscription which will open a section for them to get the update email email or send us a comment--}}
                                    <option value="Sales" selected="true">Sales</option>
                                    <option value="Editorial - Online/Newsletter">Editorial - Online/Newsletter</option>
                                    <option value="Editorial - Magazine">Editorial - Magazine</option>
                                    <option value="Circulation">Circulation</option>
                                    <option value="Jobs">Jobs</option>
                                    <option value="Technical Support">Technical Support</option>
                                </select>
                            </div>
                            <div class="form-group{{ $errors->has('firstname') ? ' has-error' : '' }}">
                                <label>First Name*</label>
                                <input type="text" class="form-control" placeholder="First Name" name="firstname" value="{{ old('firstname') }}">
                                @if ($errors->has('firstname'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('firstname') }}</strong>
                                    </span>
                                @endif
                            </div>
                            <div class="form-group">
                                <label>Last Name</label>
                                <input type="text" class="form-control" placeholder="Last Name" name="lastname" value="{{ old('lastname') }}">
                            </div>
                            <div class="form-group{{ $errors->has('email') ? ' has-error' : '' }}">
                                <label>Email address*</label>
                                <input type="text" class="form-control" placeholder="Email address" name="email" value="{{ old('email') }}">
                                @if ($errors->has('email'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('email') }}</strong>
                                    </span>
                                @endif
                            </div>
                            <div class="form-group">
                                <label>Telephone</label>
                                <input type="text" class="form-control phone-mask" placeholder="Telephone" name="phone" value="{{ old('phone') }}">
                            </div>
                            <div class="form-group">
                                <label>Country</label>
                                <input type="text" class="form-control" placeholder="Country" name="country" value="{{ old('country') }}">
                            </div>
                            <div class="form-group{{ $errors->has('comment') ? ' has-error' : '' }}">
                                <label>How can we assist you?*</label>
                                <textarea name="comment" class="form-control" cols="20" rows="5">{{ old('comment') }}</textarea>
                                @if ($errors->has('comment'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('comment') }}</strong>
                                    </span>
                                @endif
                            </div>
                            <button class="btn btn-default btn-block g-recaptcha" data-sitekey="6LeqpUQUAAAAAFq2PBGtUVUrsnhnZap8FtmDxoby" data-callback="contact_form_submit">
                                Submit
                            </button>
                            {!! Form::close() !!}
                        </div>
                        <div class="col-md-8">
                            <div id="marExMap">
                                <iframe src="https://www.google.com/maps/embed?pb=!1m14!1m8!1m3!1d3583.4317930913703!2d-80.138207!3d26.08482!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x88d9007ec4e936eb%3A0xc050574aba50b2bf!2s3200+S+Andrews+Ave%2C+Fort+Lauderdale%2C+FL+33316!5e0!3m2!1sen!2sus!4v1413825768868"
                                        width="600" height="450" frameborder="0" style="border:0"></iframe>
                            </div>
                            <!--map-->
                            <div id="mapBottom">
                                <h2>The Maritime Executive, LLC</h2>
                                <p>3200 South Andrews Avenue, Suite 100
                                    <br>
                                    Fort Lauderdale, FL 33316, USA
                                </p>
                                <p>
                                    <span class="bold">Tel:</span>
                                    +1 (954) 848 9955
                                    <br>
                                    <span class="bold">Toll-Free: +1</span>
                                    (866) 884 9034
                                    <br>
                                    <span class="bold">Fax: +1</span>
                                    (954) 848 9948
                                    <br>
                                    <span class="bold">Email:</span>
                                    <a href="mailto:info@maritime-executive.com">
                                        info@maritime-executive.com
                                    </a>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

@push('scripts')
<script type="text/javascript" src="{{ asset('libs/jquery.maskedinput.min.js') }}"></script>
    <script>

        "use strict";

        $(function () {
            $('.phone-mask').mask("(999) 999-9999");
        })

        function contact_form_submit() {

            $('#contact_form').submit();
        }
    </script>
@endpush
