@extends('layouts.site')

@push('meta')
    <title>Directory - The Maritime Executive</title>
    <meta name="description" content="Finding globally recognized companies in maritime has never been so quick and easy. Explore our extensive database today!">
    <meta name="keywords" content="">
    <meta property="og:title" content="Directory - The Maritime Executive">
    <meta property="og:url" content="https://maritime-executive.com/directory">
    <meta property="og:description" content="Finding globally recognized companies in maritime has never been so quick and easy. Explore our extensive database today.">
@endpush

@section('content')
    <section class="wrap-content list-article">
        <div class="container">
            <div class="row">

                <div class="main-content col-md-8 col-sm-8">

                    <div class="col-md-12 no-left-padding">

                        <div class="header font-firasans text-uppercase   ">
                                    <span class="title bl-6 b-color-4">
                                        <strong>Directory</strong>
                                    </span>
                                </div>


                        <div class="search-bar">
                            <div class="col-md-12 no-padding">
                                <input type="search" placeholder="Search Company" id="query">
                            </div>
                        </div>
                        <div class="btn-group btn-group-sm" role="group" aria-label="...">
                            <input type="button" class="btn btn-primary btn-sm alpha search_alpha" value="A">
                            <input type="button" class="btn btn-primary btn-sm alpha search_alpha" value="B">
                            <input type="button" class="btn btn-primary btn-sm alpha search_alpha" value="C">
                            <input type="button" class="btn btn-primary btn-sm alpha search_alpha" value="D">
                            <input type="button" class="btn btn-primary btn-sm alpha search_alpha" value="E">
                            <input type="button" class="btn btn-primary btn-sm alpha search_alpha" value="F">
                            <input type="button" class="btn btn-primary btn-sm alpha search_alpha" value="G">
                            <input type="button" class="btn btn-primary btn-sm alpha search_alpha" value="H">
                            <input type="button" class="btn btn-primary btn-sm alpha search_alpha" value="I">
                            <input type="button" class="btn btn-primary btn-sm alpha search_alpha" value="J">
                            <input type="button" class="btn btn-primary btn-sm alpha search_alpha" value="K">
                            <input type="button" class="btn btn-primary btn-sm alpha search_alpha" value="L">
                            <input type="button" class="btn btn-primary btn-sm alpha search_alpha" value="M">
                            <input type="button" class="btn btn-primary btn-sm alpha search_alpha" value="N">
                            <input type="button" class="btn btn-primary btn-sm alpha search_alpha" value="O">
                            <input type="button" class="btn btn-primary btn-sm alpha search_alpha" value="P">
                            <input type="button" class="btn btn-primary btn-sm alpha search_alpha" value="Q">
                            <input type="button" class="btn btn-primary btn-sm alpha search_alpha" value="R">
                            <input type="button" class="btn btn-primary btn-sm alpha search_alpha" value="S">
                            <input type="button" class="btn btn-primary btn-sm alpha search_alpha" value="T">
                            <input type="button" class="btn btn-primary btn-sm alpha search_alpha" value="U">
                            <input type="button" class="btn btn-primary btn-sm alpha search_alpha" value="V">
                            <input type="button" class="btn btn-primary btn-sm alpha search_alpha" value="W">
                            <input type="button" class="btn btn-primary btn-sm alpha search_alpha" value="X">
                            <input type="button" class="btn btn-primary btn-sm alpha search_alpha" value="Y">
                            <input type="button" class="btn btn-primary btn-sm alpha search_alpha" value="Z">
                        </div>

                        <div class="directory-list" id="directory_list_container">
                            @include('site.partials.directory.directory_list', ['directory_list' => $directory_list])
                        </div>
						<div class="btn-group btn-group-sm" role="group" aria-label="...">
                            <input type="button" class="btn btn-primary btn-sm alpha search_alpha" value="A">
                            <input type="button" class="btn btn-primary btn-sm alpha search_alpha" value="B">
                            <input type="button" class="btn btn-primary btn-sm alpha search_alpha" value="C">
                            <input type="button" class="btn btn-primary btn-sm alpha search_alpha" value="D">
                            <input type="button" class="btn btn-primary btn-sm alpha search_alpha" value="E">
                            <input type="button" class="btn btn-primary btn-sm alpha search_alpha" value="F">
                            <input type="button" class="btn btn-primary btn-sm alpha search_alpha" value="G">
                            <input type="button" class="btn btn-primary btn-sm alpha search_alpha" value="H">
                            <input type="button" class="btn btn-primary btn-sm alpha search_alpha" value="I">
                            <input type="button" class="btn btn-primary btn-sm alpha search_alpha" value="J">
                            <input type="button" class="btn btn-primary btn-sm alpha search_alpha" value="K">
                            <input type="button" class="btn btn-primary btn-sm alpha search_alpha" value="L">
                            <input type="button" class="btn btn-primary btn-sm alpha search_alpha" value="M">
                            <input type="button" class="btn btn-primary btn-sm alpha search_alpha" value="N">
                            <input type="button" class="btn btn-primary btn-sm alpha search_alpha" value="O">
                            <input type="button" class="btn btn-primary btn-sm alpha search_alpha" value="P">
                            <input type="button" class="btn btn-primary btn-sm alpha search_alpha" value="Q">
                            <input type="button" class="btn btn-primary btn-sm alpha search_alpha" value="R">
                            <input type="button" class="btn btn-primary btn-sm alpha search_alpha" value="S">
                            <input type="button" class="btn btn-primary btn-sm alpha search_alpha" value="T">
                            <input type="button" class="btn btn-primary btn-sm alpha search_alpha" value="U">
                            <input type="button" class="btn btn-primary btn-sm alpha search_alpha" value="V">
                            <input type="button" class="btn btn-primary btn-sm alpha search_alpha" value="W">
                            <input type="button" class="btn btn-primary btn-sm alpha search_alpha" value="X">
                            <input type="button" class="btn btn-primary btn-sm alpha search_alpha" value="Y">
                            <input type="button" class="btn btn-primary btn-sm alpha search_alpha" value="Z">
                        </div>
                    </div>
                </div>
				<div class="magsidebar">
                @include('site.partials.site.right_side_column', ['side_article_content' => $side_article_content])
				</div>
            </div>
			 @include('site.partials.ads.625x50_1')
        </div>
    </section>
@endsection

@push('scripts')
    <script>
        $(function () {

            $('#query').keyup(function () {

                $.post('/directory-search', {value: this.value}, function (data) {

                    $('#directory_list_container').html(data);
                });
            });

            $('.search_alpha').click(function () {

                $('#query').val('');

                $.post('/directory-search', {value: this.value, alpha: true}, function (data) {

                    $('#directory_list_container').html(data);
                });
            });
        });
    </script>
@endpush