@extends('layouts.site')

@section('content')
    <section class="wrap-content">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <h1>
                        <span class="red bold">MarEx</span>
                        Directory
                    </h1>
                    <a href=""></a>
                    <div class="row">
                        <div class="col-md-5">
                            <p>
                                @include('site.partials.site.image', ['source' => $directory->logo, 'alternate_text' => $directory->company])
                            </p>
                            <h2 style="margin: 10px 0;">{{ $directory->company }}</h2>
                            <address>
                                {{ $directory->address }}
                            </address>
                            <p style="margin-top: 10px;">
                                @if($directory->phone)
                                    Phone: {{ $directory->phone }}
                                    <br>
                                @endif
                                @if($directory->fax)
                                    Fax: {{ $directory->fax }}
                                    <br>
                                @endif
                                @if($directory->website)
                                        <a class="directory-text" href="{{ $directory->website }}" title="{{ $directory->company }}" target="_blank">{{ $directory->website }}</a>
                                @endif
                            </p>
                            <p>
                                {!! $directory->description !!}
                            </p>
                        </div>
                        <div class="col-md-7">
                            <div id="map" style="width: 100%; height: 400px;"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

@push('scripts')
<script>
    function initMap() {
        var uluru = {lat: {{ $directory->latitude }}, lng: {{ $directory->longitude }}};
        var map = new google.maps.Map(document.getElementById('map'), {
            zoom: 4,
            center: uluru
        });
        var marker = new google.maps.Marker({
            position: uluru,
            map: map
        });
    }
</script>
<script async defer
        src="https://maps.googleapis.com/maps/api/js?key=AIzaSyCEZ4IWWK8rV5cqAbv58ak_jBUuiCIEjDk&callback=initMap">
</script>
@endpush