@extends('layouts.site')

@push('meta')
    <title>Events</title>
    
@endpush

@section('content')
    <div class="container">
        <div class="row" id="events-wrapper">
            @include('site.partials.homepage.eventsnew', ['events' => $events, 'months' => $months])
        </div>
    </div>
@endsection()
@push('scripts')
    <script>

        "use strict";

        var article_categories = $('#article_categories');
        var events             = $('#events');

        $(function () {

            $.post('/homepage/article_categories', {}, function (data) {

                article_categories.html(data);
            });

            $.post('/homepage/events', {}, function (data) {

                events.html(data);

                $('.event_month').click(function (e) {

                    e.preventDefault();

                    var link = $(this).data('link');

                    $.post(link, null, function (data) {

                        $('#events_tbody').html(data);

                        $('.event_link', events).click(function () {

                            var link = $(this).data('link');

                            window.open(link);
                        });
                    });
                });

                $('.event_link').click(function () {

                    var link = $(this).data('link');

                    window.open(link);
                });
            });
        });
    </script>
@endpush