@extends('layouts.site')

@push('meta')
<title>Feature Articles - The Maritime Executive </title>
<meta name="description" content="Leading analysis from top maritime industry experts with an emphasis on maritime law, policy and issues. ">
<meta name="keywords" content="">
<meta property="og:title" content="Feature Articles - The Maritime Executive ">
<meta property="og:url" content="https://maritime-executive.com/features">
<meta property="og:description" content="Leading analysis from top maritime industry experts with an emphasis on maritime law, policy and issues. ">
@endpush

@section('content')
<section class="wrap-content">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
			  <div class="pt-1 hidden-sm hidden-xs">
                    
					<div class="header font-firasans text-uppercase featuretop col-md-6 ">
                                    <span class="title bl-6 b-color-4">
                                        <strong>Feature</strong> Articles
                                    </span>
                                </div>
					<div class="text-right col-md-6">
                         @include('site.partials.get_social.social-icons', ['show_title' => true])
                    </div>
					
                </div>
				<div class="clearfix"></div>
                <div class="search-article bg-4">
                    <div class="clearfix" data-toggle="buttons">
                        <div class="col-sm-4 col-xs-12">
                            <label class="btn btn-primary col-sm-12 col-xs-12">
                                <input type="checkbox" class="features_search d-none" name="editorials" id="option2" autocomplete="off" value="editorials">
                                Editorials
                            </label>
                        </div>
                        <div class="col-sm-4 col-xs-12">
                            <label class="btn btn-primary JustifyCenter col-sm-12 col-xs-12">
                                <input type="checkbox" class="features_search d-none" name="features" id="option3" autocomplete="off" value="features">
                                Features
                            </label>
                        </div>
                        <div class="col-sm-4 col-xs-12">
                            {!! Form::select('author_id', $authors, NULL, ['id' => 'search_author_select', 'class' => 'col-sm-12 features_search', 'placeholder' => 'Select an Author...']) !!}
                            <i class="fas fa-sort search-icon"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="clearfix"></div>

        <div class="row">

            <div class="col-md-9 col-sm-7">
              

                <div class="no-padding selectauthor">
                    <div class="blog-item feature-item">
                        <div class="image p-0 col-md-6 col-sm-12 col-xs-12 no-padding-xs">
                            @include('site.partials.site.image', ['image' => $main_article->article_image, 'class' => 'img-full'])
                        </div>
                        <div class="desc col-md-6 col-sm-12 col-xs-12 no-padding-xs">
                            <h1 class="no-top-margin title">
                                <a href="{{ $main_article->link }}">{{ $main_article->title }}</a>
                            </h1>
                            <div class="text-uppercase">
                                @include('site.partials.article.author_date_time', ['article' => $main_article, 'date' => TRUE])
								@if($main_article->cattitle !='' )<a href="javascript:void(0)" class="read-more2">Posted in: {{ $main_article->cattitle }}</a> @endif
							</div>
							
                            <p class="summary">
							{{ str_limit($main_article->content_summary, 130, $end = '...') }}
                            </p>
                            
                        </div>
                    </div>
                </div>

                <div class="clearfix"></div>

                <div class="l1-ads-wrapper hidden-sm hidden-md hidden-lg mt-1">
                    @include('site.partials.ads.990x90_1')
                </div>

              

                <div class="main-content features" id="feature_content_box">
                    @include('site.partials.features.feature_content_box', [
                    'secondary_stories' => $secondary_stories,
                    'tertiary_stories' => $tertiary_stories
                    ])
                </div>
				  <!--div class="hidden-sm hidden-md hidden-lg mt-1 text-center feature">
				  {{-- @include('site.partials.get_social.social-icons', ['show_title' => true])

                    @include('site.partials.ads.300x250_1')

                    @include('site.partials.ads.300x250_2')
					@include('site.partials.ads.300x250_3')
				  @include('site.partials.ads.300x250_4') --}}
					
					
					
                </div-->
				<div class="">
				@include('site.partials.article.more_articles_button', ['more_news_id' => 'features_more_news', 'path' => 'features', 'limit' => 3, 'offset' => 10, 'article_content_box_id' => 'feature_content_box'])
				</div>
            </div>
            <div class="sidebar magsidebar text-center col-md-3 col-sm-5">

               

                @include('site.partials.ads.300x250_1')

                @include('site.partials.ads.300x250_2')

                @include('site.partials.ads.300x250_3')

                @include('site.partials.ads.300x250_4')

            </div>
        </div>
 <div class="secondary-articles-ads-wrapper l2-ads-wrapper hidden-lg hidden-md hidden-sm">
    @include('site.partials.ads.625x50_1_mobile')
</div>
        <div class="row">
            @include('site.partials.ads.subscribe_now')
        </div>

        <div class="clearfix container l2-ads-wrapper">
            @include('site.partials.ads.728x90')
        </div>

    </div>
</section>
@endsection

@push('scripts')
<script>
    $(function() {

        $('#features_more_news').click(function() {

            var feature_more_news_obj = $(this);
            var limit = $(this).data('limit');
            var offset = $(this).data('offset');

            features_search({
                limit: limit,
                offset: offset
            }, function(data) {

                feature_more_news_obj.data('offset', (limit + offset));

                $('#feature_content_box').append(data);
            });
        });

        $('.features_search').change(function() {

            //reset the offset of more articles when a search is done
            $('#features_more_news').data('offset', 9);

            features_search({}, function(data) {

                $('#feature_content_box').html(data);
            });
        });
    });

    function features_search(data, callback) {

        var features = $('.features_search[name=features]').not(':checked').val();
        var editorials = $('.features_search[name=editorials]').not(':checked').val();
        var author_id = $('.features_search[name=author_id]').val();

        data = $.extend({}, {
            features: features,
            editorials: editorials,
            author_id: author_id
        }, data);

        console.log('Items in data');
        console.log(data);

        $.post('/features/search', data, function(data) {

            if (callback) {
				$('.selectauthor').hide();
                callback(data);
            }
        });
    }
</script>
@endpush