@extends('layouts.site')

@push('meta')
<title>The Maritime Executive: Maritime News | Marine News</title>
<meta name="description" content="The maritime industry’s leading source for breaking maritime and marine news including shipping news, offshore news, piracy news and more">
<meta name="keywords" content="maritime executive,maritime news,marine news,offshore news,shipping news,cargo vessel news,shipbuilding news,maritime industry, maritime newsletter,ship jobs">
<meta property="og:title" content="The Maritime Executive: Maritime News | Marine News">
<meta property="og:url" content="https://maritime-executive.com/">
<meta http-equiv="Pragma" content="no-cache">
<meta http-equiv="Expires" content="-1">
<meta http-equiv="CACHE-CONTROL" content="NO-CACHE">


<meta property="og:description" content="The maritime industry’s leading source for breaking maritime and marine news including shipping news, offshore news, piracy news and more">
@endpush

@section('content')
<div class="home-page">
    <section class="wrap-content">
        <div class="container">
            <div class="row">
                <div class="main-content col-lg-9 col-md-8 col-sm-8 p-0 pt-15">

                    <div class="clearfix home-content-first">
                        <div class="col-md-8 primary">
                            @include('site.partials.article.top_article')
                        </div>
						<div class="mobileads hidden-md hidden-sm hidden-lg" >
					 @include('site.partials.ads.300x250_1_mobile')
					 </div>
                        <div class="col-md-4 secondary">
                            <div class="stories-list-wrapper more-top-stories" id="more-top-stories-container">
                                <div class="header font-firasans">
                                    <span class="title bl-6 b-color-4">
                                        <strong>TRENDING</strong> STORIES
                                    </span>
                                </div>
                                @include('site.partials.article.stories-list', ['articles' => $last3days])
                            </div>
							<div class="mobileads hidden-md hidden-sm hidden-lg" >
					 @include('site.partials.ads.300x250_2_mobile')
					 </div>
                            <div class="stories-list-wrapper trending-stories" id="trending-stories-container">
                                <div class="header">
                                    <span class="title bl-6 b-color-4">
                                        <strong>EDITORIALS</strong>
                                    </span>
									 <!--span class="editor-expand-btn float-right">
                                        <i class="fal fa-plus"></i>
                                    </span-->
                                </div>
								<div class="editor-articles-content ">
                                @include('site.partials.article.stories-list', ['articles' => $editorials])
								</div>
                            </div>
                            <!--div class="stories-list-wrapper blog-stories" id="blog-stories-container">
                                <div class="header">
                                    <span class="title bl-6 b-color-4">
                                        <strong>BLOGS</strong>
                                    </span>
                                    <span class="blog-expand-btn float-right">
                                        <i class="fal fa-plus"></i>
                                    </span>
                                </div>
                                <div class="blog-articles-content d-none">
                                    @include('site.partials.article.stories-list', ['articles' => $blogs])
                                </div>
                            </div-->
                        </div>
                    </div>

                    <div class="clearfix"></div>
					<div class="mobileads hidden-md hidden-sm hidden-lg" >
					 @include('site.partials.ads.300x250_3_mobile')
					 </div>
					<div class="top-list-wrapper col-md-12 ">
<div class="header font-firasans">
                                    <span class="title bl-6 b-color-4">
                                        <strong>MORE</strong> TOP STORIES
                                    </span>
                                </div>
								</div>
				 <div class="topstory-articles">
                        @include('site.partials.article.top_article_home', [
                        'articles' => $more_top_stories,
                        'grid_class' => 'col-lg-6 col-md-6 col-sm-6 col-xs-12',
                        'category_title_class' => 'bl-4 b-color-4'
                        ])
                    </div>
					<div class="mobileads hidden-md hidden-sm hidden-lg" >
					 @include('site.partials.ads.300x250_4_mobile')
					 </div>
					<div class="hidden-sm">
					
					<div class="top-list-wrapper col-md-12">
<div class="header font-firasans">
                                    <span class="title bl-6 b-color-4">
                                        <strong>STORIES</strong> BY CATEGORY
                                    </span>
                                </div>
								</div>
                    <div class="secondary-articles">
					
                        @include('site.partials.article.teaser-grid-category', [
                        'articles' => $categoriesupper,
                        'grid_class' => 'col-lg-4 col-md-4 col-sm-4 col-xs-12',
                        'category_class' => 'bg-1'
                        ])
                    </div>
                 
                    <div class="clearfix"></div>

                    <div class="secondary-articles-ads-wrapper l2-ads-wrapper">
                        @include('site.partials.ads.625x50_1')
                    </div>
					<div class="clearfix"></div>

                    <div class="secondary-articles">
					
                        @include('site.partials.article.teaser-grid-category', [
                        'articles' => $categoriesports,
                        'grid_class' => 'col-lg-4 col-md-4 col-sm-4 col-xs-12',
                        'category_class' => 'bg-1'
                        ])
                    </div>
					 <div class="clearfix"></div>
					 </div>
 
                </div>
                <div class="sidebar text-center col-lg-3 col-md-4 col-sm-4 col-xs-12">

                    @include('site.partials.get_social.social-icons', ['show_title' => true])
				<div class="hidden-xs" >
                    @include('site.partials.ads.300x250_1')

                    @include('site.partials.ads.300x250_2')

                    @include('site.partials.ads.300x250_3')

                    @include('site.partials.ads.300x250_4')
					</div>
					

                    <div class="stories-list-wrapper trending-stories text-left pt-1" id="trending-stories-container">
                        <div class="header">
                            <span class="title bl-6 b-color-4">
                                <strong>FEATURED</strong> STORIES
                            </span>
                        </div>
                        @include('site.partials.article.featured-list', ['articles' => $featured_stories])
						
                    </div>
					 <div class="stories-list-wrapper blog-stories text-left pt-1" id="blog-stories-container">
                                <div class="header">
                                    <span class="title bl-6 b-color-4">
                                        <strong>BLOGS</strong>
                                    </span>
                                    <span class="blog-expand-btn float-right">
                                        <i class="fal fa-plus"></i>
                                    </span>
                                </div>
                                <div class="blog-articles-content d-none">
                                    @include('site.partials.article.stories-list', ['articles' => $blogs])
                                </div>
                        </div>
					 <div class="stories-list-wrapper podcast-stories text-left pt-1" id="podcast-stories-container">
                                <div class="header">
                                    <span class="title bl-6 b-color-4">
                                        <strong>PODCASTS</strong>
                                    </span>
                                    <span class="blog-expand-btn float-right">
                                        <i class="fal fa-plus"></i>
                                    </span>
                                </div>
                                <div class="podcast-articles-content d-none">
                                    @include('site.partials.article.stories-list', ['articles' => $podcast])
                                </div>
                        </div>
					
                </div>
            </div>
			
			<div class="row hidden-md hidden-xs hidden-lg">
			
			<div class="col-md-12 p-0">
			<div class="top-list-wrapper col-md-12">
<div class="header font-firasans">
                                    <span class="title bl-6 b-color-4">
                                        <strong>STORIES</strong> BY CATEGORY
                                    </span>
                                </div>
								</div>
                    <div class="secondary-articles">
					
                        @include('site.partials.article.teaser-grid-category', [
                        'articles' => $categoriesupper,
                        'grid_class' => 'col-lg-4 col-md-4 col-sm-4 col-xs-12',
                        'category_class' => 'bg-1'
                        ])
                    </div>

                    <div class="clearfix"></div>

                    

                    <div class="secondary-articles">
					
                        @include('site.partials.article.teaser-grid-category', [
                        'articles' => $categoriesports,
                        'grid_class' => 'col-lg-4 col-md-4 col-sm-4 col-xs-12',
                        'category_class' => 'bg-1'
                        ])
                    </div>
					 <div class="clearfix"></div>
			</div>
			</div>
           
        </div>
    </section>

    

    <div class="container">
        <div class="row">
            <div class="main-content col-md-12 col-sm-12 custom_head_set">
			<div class="top-list-wrapper col-md-12">
<div class="header font-firasans">
                                    <span class="title bl-6 b-color-4">
                                        <strong>MORE</strong> STORIES BY CATEGORY
                                    </span>
                                </div>
								</div>
                <!--div class="categories-articles-preview secondary-articles"-->
				 <div class="secondary-articles footercategory">
				{{--@include('site.partials.article.category-articles-list', ['categories' => $category_summaries]) --}}
					@include('site.partials.article.teaser-grid-category', [
                        'articles' => $category_summaries,
                        'grid_class' => 'col-lg-3 col-md-3 col-sm-6 col-xs-12',
                        'category_class' => 'bg-1'
                        ])
                </div>
				<!--div class="stories-list-wrapper " id="more_categories">
                                <div class="header">
                                    <span class="title bl-6 b-color-4 more-expand-btn">
                                        <strong>SHOW ALL CATEGORIES  <i class="fal fa-plus"></i></strong> 
                                    </span>
                                    
                                </div>
                                <div class="more_categories-content d-none categories-articles-preview">
								{{-- @include('site.partials.article.category-articles-list', ['categories' => $category_more]) --}}
                                </div>
                            </div-->
            </div>
			
            
        </div>
    </div>
@include('site.partials.ads.subscribe_now')
    

    <div class="container">
        <div class="row" id="events-wrapper">
            @include('site.partials.homepage.events', ['events' => $eventsData['events'], 'months' => $eventsData['months']])
        </div>
    </div>

    
	<div class="clearfix"></div>
				
					<div class="ajax-load text-center" style="display:none">
	<p><img src="img/loader.gif">Loading More news</p>
</div>
					<input type="hidden" id="exculdeids" name="" value="<?php echo base64_encode(serialize($articleids));?>">
					
					<div class="clearfix"></div>
</div>
@endsection
@push('scripts')
    <script>

        "use strict";

        var article_categories = $('#article_categories');
        var events             = $('#events-wrapper');

        $(function () {

            $.post('/homepage/article_categories', {}, function (data) {

                article_categories.html(data);
            });

            /* $.post('/homepage/events', {}, function (data) {

                events.html(data); */

                $('.event_month').click(function (e) {

                    e.preventDefault();

                    var link = $(this).data('link');

                    $.post(link, null, function (data) {

                        $('#events_tbody').html(data);

                        $('.event_link', events).click(function () {

                            var link = $(this).data('link');

                            window.open(link);
                        });
                    });
                });

                $('.event_link', events).click(function () {

                    var link = $(this).data('link');

                    window.open(link);
                });
				  var page = 1;
				/* $(window).scroll(function() {
					if($(window).scrollTop() + $(window).height() >= $(document).height()-100) {
						page++;
						loadMoreData(page);
					}
				}); */
				function loadMoreData(page){
						var ids = $('#exculdeids').val();
					var datastring = 	'ids='+ids+'&page='+page;
	  $.ajax(
	        {
	            url: '/loaddata',
	            type: "POST",
				data:datastring,
	            beforeSend: function()
	            {
	                $('.ajax-load').show();
	            }
	        })
	        .done(function(data)
	        {
	            if(data == " "){
	                $('.ajax-load').html("No more records found");
	                return;
	            }
	            $('.ajax-load').hide();
	            $("#post-data").append(data);
	        })
	        .fail(function(jqXHR, ajaxOptions, thrownError)
	        {
	              /* alert('server not responding...'); */
	        });
	}
           /*  }); */
        });
    </script>
@endpush