@extends('layouts.site')

@push('meta')
    <title>{{ $category->meta_title }}</title>
    <meta name="description" content="{{ $category->meta_description }}">
    <meta name="keywords" content="{{ $category->meta_keywords }}">
    <meta property="og:title" content="{{ $category->meta_title ?? $category->title }}">
    <meta property="og:url" content="{{ $category->link }}">
    <meta property="og:description" content="{{ $category->meta_description }}">
@endpush

@section('content')
    <section class="wrap-content list-article">
        <div class="container">
            <div class="row">
			 
					 <div class="header font-firasans text-uppercase   ">
                                    <span class="title bl-6 b-color-4">
                                        <strong>Jobs</strong>
                                    </span>
                                </div>
                <div class="main-content col-md-8 col-sm-8">
                    <div class="row">
                        <div class="col-md-6">
                            <a target="_blank" href="https://www.maritimeprofessionals.net/Employment/RegisterJobSeeker.aspx " class="btn btn-primary btn-lg btn-block">Register Job Seeker</a>
                        </div>
                        <div class="col-md-6">
                            <a href="/job/pricing" class="btn btn-primary btn-lg btn-block">Post a Job</a>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12 jobspage">
                           

                            @include('site.partials.article.more_articles_content', ['articles' => $main_articles])

                            <div class="clearfix"></div>

                            @include('site.partials.article.more_articles_button', ['title' => 'See More Jobs', 'article_content_box_id' => 'article_container', 'slug' => $category->slug, 'path' => $category->slug, 'limit' => 4, 'offset' => 10])

                            <div class="clearfix"></div>

                           
                        </div>
                    </div>
                </div>
				<div class="magsidebar">
                @include('site.partials.site.right_side_column', ['side_article_content' => $side_article_content])
				</div>
            </div>
			 @include('site.partials.ads.625x50_1')
        </div>
    </section>
@endsection()