@extends('layouts.site')

@push('meta')
<title>Digital Magazine- The Maritime Executive</title>
<meta name="description" content="Digital version of The Maritime Executive magazine, which features top maritime executives and their businesses from around the world.">
<meta name="keywords" content="">
<meta property="og:title" content="Digital Magazine - The Maritime Executive">
<meta property="og:url" content="https://maritime-executive.com/magazine-digital/magazine-digital">
<meta property="og:description" content="Digital version of The Maritime Executive magazine, which features top maritime executives and their businesses from around the world.">
@endpush

@section('content')
<section class="magazine-section-one">
    <div class="container">
        <div class="row">
            <div class="col-md-9">
                <div class="pt-1 pb-1">
                    
					<div class="header font-firasans text-uppercase  ">
                                    <span class="title bl-6 b-color-4">
                                        <strong>Magazine</strong> Editions
                                    </span>
                                </div>
                </div>
                <div class="">
                    <div class="blog-item big feature-item text-center">
                        <a href="{{ $current_edition->link }}"> <div class="image p-0 col-sm-6 col-xs-12 no-padding-xs">
                            <img src="https://maritime-executive.com{{ $current_edition->print_image }}" class="img-responsive">
                        </div></a>
                        <div class="desc col-sm-6 col-xs-12 no-padding-xs magazinesummary text-left paddingmobile">
							<h4>July-August 2019 Edition</h4>
                            <h1 class="no-top-margin title">
                                <a href="{{ $current_edition->link }}">
                                  {{  $current_edition->title }}
                                </a>
                            </h1>
							<h4>Case Study</h4>
                            <div class="summary casestudy">
                               <h2 class="ctitle">{{ $current_edition->cs_title }}</h2>
                               <h2 class="csubtitle">
                                {{ $current_edition->cs_sub_title }}
								</h2>
								<h3 class="cauthor">
								 @if($current_edition->firstname!='') By @endif {{ $current_edition->firstname }} {{ $current_edition->lastname }}
								</h3>
                            </div>
							<h4>Executive Interview</h4>
							<div class="summary casestudy">
                              <h2 class="ctitle"> {{ $current_edition->ei_title }}</h2>
                               <h2 class="csubtitle">
                                {{ $current_edition->ei_sub_title }}
								</h2>
								<h3 class="cauthor">
								 @if($current_edition->eifirstname!='') By @endif {{ $current_edition->eifirstname }} {{ $current_edition->eilastname }}
								</h3>
                            </div>
                        </div>
                        <div class="ad_btn">
                            <a href="{{ $current_edition->link }}" class="btn bg-5 color-white bold">READ NOW</a>
                        </div>
                    </div>
                </div>

                <div class="clearfix"></div>
                <hr />
                <div class="clearfix"></div>

                <div class="col-md-6 col-sm-6">

                </div>
                <div class="col-md-6 col-sm-6 hidden-xs">
                    <div class="col-md-12">

                    </div>
					<a href="{{ $current_edition->link }}" class="read-more-magzine hidden-lg hidden-md hidden-sm">Read more</a>
                </div>
                

                <div class="clearfix"></div>
				<div class="pt-1 pb-1">
                    <h4 class="bl-6 b-color-4 text-uppercase">
                        <span class="bold">Previous</span> Editions
                    </h4>
                </div>
                <div class="magazine-slider">
                    <div class="slider">
                        @foreach($editions as $edition)
                        <a href="/magazine/{{ $edition->year }}/{{ $edition->articleMagazineMonth->id }}" class="slide">
                            <img src="https://maritime-executive.com{{ $edition->print_image }}" class="img-responsive">
                            <h4>{{ $edition->articleMagazineMonth->name }} {{ $edition->year }}</h4>
                        </a>
                        @endforeach
                    </div>
                </div>

                <div class="clearfix mt-2"></div>

                

            </div>

            <div class="sidebar text-center col-lg-3 col-md-4 col-sm-4 col-xs-12 pt-1">
                @include('site.partials.get_social.social-icons', ['show_title' => true])

                @include('site.partials.ads.300x250_1')

                @include('site.partials.ads.300x250_2')

                @include('site.partials.ads.300x250_3')

                @include('site.partials.ads.300x250_4')
            </div>
        </div>
		 @include('site.partials.ads.625x50_1')
        <div class="clearfix">
            @include('site.partials.ads.subscribe_now')
        </div>

        

    </div>
</section>

@endsection

@push('scripts')
    <script>
        "use strict";
        $(function () {
            $('.magazine-slider .slider').slick({
                slidesToShow  : 6,
                slidesToScroll: 1,
                arrows        : true,
                initialSlide  : {{ ($editions->count() - 5) }},
                infinite      : false,
                responsive    : [
                    {
                        breakpoint: 768,
                        settings  : {
                            slidesToShow: 3
                        }
                    }
                ]
            });
        })
    </script>
@endpush