@extends('layouts.site')

@push('meta')
    <title>MarEx Newsletter - The Maritime Executive</title>
    <meta name="description" content="Up to the minute maritime business and corporate news from one of the oldest and most esteemed industry newsletters">
    <meta name="keywords" content="">
    <meta property="og:title" content="MarEx Newsletter - The Maritime Executive">
    <meta property="og:url" content="https://maritime-executive.com/newsletter">
    <meta property="og:description" content="Up to the minute maritime business and corporate news from one of the oldest and most esteemed industry newsletters">
	<meta http-equiv="cache-control" content="no-cache" />
<meta http-equiv="Pragma" content="no-cache" />
<meta http-equiv="Expires" content="-1" />
@endpush

{{-- todo-hammy v2 need to add in UTM as part of link for newsletter --}}
@section('content')
    <section class="wrap-content">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
				
                    <!--  Form Select -->
                   
                </div>
            </div>
            <div class="row">
				
                <div class="col-md-12" id="newsletter_template_containers">
				<div class="l1-ads-wrappernews">
					
					<div class="bl-6 header font-firasans text-uppercase rs_custom">
                                    <span class="title bl-6 b-color-4">
                                        <strong>THE MARITIME Executive</strong> Newsletter
                                    </span>
                                </div>
					</div>
					<div class="l1-ads-wrappernews">
					 <div class="form-group rs_custom">
                        {!! Form::select('newsletter_id', isset($newsletter_list) && $newsletter_list->count() > 0 ? $newsletter_list : ['List is unavailable'], NULL, ['id' => 'newsletter_dropdown', 'class' => 'form-control']) !!}
                    </div>
					</div>
					<div id="newsletter_template_container">
                    @if(isset($banner_list) && isset($article_list))
                        @include('newsletters.index')
                    @endif
					</div>
                </div>
			
            </div>
        </div>
    </section>
@endsection

@push('scripts')
    <script>
        $(function () {

            $('#newsletter_dropdown').change(function () {

                var newsletter_id = this.value;

                console.log("Newsletter ID is " + newsletter_id);

                $.post('/newsletter/get_newsletter_template_block', {newsletter_id: newsletter_id}, function (data) {

                  $('#newsletter_template_container').html(data);

                  var new_url = "https://www.maritime-executive.com/newsletter/" + newsletter_id;
                  var alt_new_url = "https://www.maritime-executive.com/newsletter_click_article?article_slug=" + newsletter_id;

                  $('#newsletter_view_link').attr("href", new_url);
                });

            });
        });
    </script>
@endpush
