@extends('layouts.site')

@push('meta')
    <title>Search Articles- The Maritime Executive</title>
    <meta name="description" content="Delivering the most up-to-the-minute news, opinions and insight in maritime training, finance and law.">
    <meta name="keywords" content="">
    <meta property="og:title" content="Search Articles - The Maritime Executive">
    <meta property="og:url" content="https://maritime-executive.com/search?key={{ $query }}">
    <meta property="og:description" content="Delivering the most up-to-the-minute news, opinions and insight in maritime training, finance and law.">
@endpush

@section('content')
    <section class="wrap-content list-article">
        <div class="container">
            <div class="main-content col-md-10 col-sm-10">

                <h1><span class="DarkerGray">Search results for "{{ $query }}"</span></h1>

                <div class="search_article_container">
                    <div class="list-group">
                        @foreach($articles as $article)
                            @if ($article->published_at != 0 && $article->published_at <= $now)
                                <button type="button" class="search_article_link list-group-item" data-link="{{ $article->link }}">
                                    <div class="col-md-2">@include('site.partials.site.image', ['image' => $article->article_image])</div>
                                    <div class="col-md-10">
                                        <h4>{{ $article->title }}</h4>
                                        <p>
                                            {{ $article->published_at }}
                                        </p>
                                    </div>
                                </button>
                            @endif
                        @endforeach
						 {!! $articles->appends(request()->query())->links() !!} 
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

@push('scripts')
<script>
    $(function () {
        $('.search_article_container').on('click', '.search_article_link', function () {
            var link = $(this).data('link');
            window.open(link,  '_self');
        })
    });
</script>
@endpush
