@extends('layouts.site')

@push('meta')
    <title>Search Articles- The Maritime Executive</title>
    <meta name="description" content="Delivering the most up-to-the-minute news, opinions and insight in maritime training, finance and law.">
    <meta name="keywords" content="">
    <meta property="og:title" content="Search Articles - The Maritime Executive">
    <meta property="og:url" content="https://maritime-executive.com/search?key={{ $query }}">
    <meta property="og:description" content="Delivering the most up-to-the-minute news, opinions and insight in maritime training, finance and law.">
@endpush
@php
function shorten_text($text, $max_length = 140, $cut_off = '...', $keep_word = false)
{
    if(strlen($text) <= $max_length) {
        return $text;
    }

    if(strlen($text) > $max_length) {
        if($keep_word) {
            $text = substr($text, 0, $max_length + 1);

            if($last_space = strrpos($text, ' ')) {
                $text = substr($text, 0, $last_space);
                $text = rtrim($text);
                $text .=  $cut_off;
            }
        } else {
            $text = substr($text, 0, $max_length);
            $text = rtrim($text);
            $text .=  $cut_off;
        }
    }

    return $text;
}
@endphp
@section('content')
    <section class="wrap-content list-article">
        <div class="container">
            <div class="main-content col-md-10 col-sm-10">

                <h1><span class="DarkerGray">{{ $articles->total() }} records found matching your search for "{{ $query }}"</span></h1>

                <div class="search_article_container">
                    <div class="list-group">
                        @foreach($articles as $article)
							
                            @if ($article->published_at != 0 && $article->published_at <= $now)
                                <button type="button" class="search_article_link list-group-item addsearch" data-link="{{ $article->link }}">
							<a href="{{ $article->link }}">
                                    <div class="col-md-2">@include('site.partials.site.image', ['image' => $article->article_image])</div>
                                    <div class="col-md-10">
									 
                                        <h4>@php print 
										
 preg_replace('/'.implode('|', $searchValues).'/i', '<span class="searchback"><b>$0</b></span>', $article->title);
										  @endphp</h4>
										<p class="summary">
										
                        @php print preg_replace('/'.implode('|', $searchValues).'/i', '<span class="searchback"><b>$0</b></span>', shorten_text($article->content_summary,140, "...",true)); @endphp
                    </p>
                                        <p class="searchfoot">
										
										Published: @php print date("m-d-Y",strtotime($article->published_at)); @endphp  | By: @php print preg_replace("#". preg_quote($query) ."#i", "<b class='searchback'>$query</b>", $article->firstname." ".$article->lastname );  @endphp  
										 
                                        </p>
                                    </div>
									</a>
                                </button>
                            @endif
                        @endforeach
						 {!! $articles->appends(request()->query())->links() !!} 
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

@push('scripts')
<script>
    /* $(function () {
        $('.search_article_container').on('click', '.search_article_link', function () {
            var link = $(this).data('link');
            window.open(link,  '_self');
        })
    }); */
</script>
@endpush
