<div class="teaser-grid-wrapper">
    @foreach($articles as $key => $article)
	
    <article class="article {{ $grid_class }}">
        <div class="data-wrapper">
            <div class="blog-item">
                <p class="category {{ @$category_class }} text-uppercase bold font-firasans">
                    <a href="{{ $article->link }}" target="_blank"><span class="{{ @$category_title_class }}">{{ $article->title }}</span></a>
                </p>
				<a href="{{ $article->top_article->link }}" target="_blank" class="font-firasans">
                <div class="image no-padding-xs">
                    @include('site.partials.site.image', ['image' => $article->top_article->article_image])
                </div></a>
                <div class="desc body no-padding-xs">

                    <h2 class="title">
                        <a href="{{ $article->top_article->link }}" target="_blank" class="font-firasans">{{ str_limit($article->top_article->title, 78, $end = '...') }}</a>
                    </h2>

                    @include('site.partials.article.author_date_time', ['article' => $article, 'date' => TRUE])

                    <p class="summary">
                        {{ $article->top_article->content_summary }}
                    </p>

                    <a href="{{ $article->link }}" target="_blank" class="read-more">Continue Reading...</a>
                </div>
            </div>
        </div>
		<ul class="other-category-articles-wrapper no-padding homepagecategory">
        @foreach($article->articles AS $articles)
        <li class="article">
            <a href="{{ $articles->link }}" target="_blank" class="title font-roboto">{{ $articles->title }}</a>
        </li>
        @endforeach
    </ul>
    </article>
	
    
    @endforeach
	
</div>