<header>
    <div class="container">
        <div class="row">
            <div class="col-sm-6" align="right" style="padding-top: 15px;">
                <a href="/" class="logo">
                    <img src="/media/images/site/logo/marexlogo2018.png" class="img-responsive" alt="Maritime Executive Logo" width="250">
                </a>
            </div>
            <div class="col-sm-6">
                <div class="wrap-search col-sm-6" align="left">
                    @include('site.partials.site.search', ['button_id' => 'header_search', 'input_id' => 'header_search_content'])
                </div>
            </div>
        </div>
    </div>
    <div class="ribbon">
        <div class="container">
            <div class="row">
                <div class="col-md-12 col-sm-12 col-xs-12">
                    <a class="mobile-menu hidden-lg hidden-md" href="">
                        <img src="/media/images/site/menu/mobile-menu.png">
                    </a>
                    <nav>
                        <ul>
                            <li>
                                <a href="/">news</a>
                            </li>
                            <li>
                                <a href="/features">features</a>
                            </li>
                            <li>
                                <a href="/podcast">Podcasts</a>
                            </li>
                            <li>
                                <a href="/magazine">magazine</a>
                            </li>
                            <li>
                                <a href="/newsletter">newsletter</a>
                            </li>
                            <li>
                                <a href="/blog">blogs</a>
                            </li>
                            <li>
                                <a href="/directory">directory</a>
                            </li>
                            <li>
                                <a href="/job">Jobs</a>
                            </li>
                            <li>
                                <a href="http://mediakit.maritime-executive.com">advertise</a>
                            </li>
                            <li>
                                <a href="/subscribe">subscribe</a>
                            </li>
                        </ul>
                    </nav>
                </div>
            </div>
        </div>
    </div>
</header>

<div class="modal fade" tabindex="-1" role="dialog" id="search_modal">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                @include('site.partials.site.search', ['button_id' => 'modal_search', 'input_id' => 'modal_search_content'])
            </div>
            <div class="modal-body" id="search_modal_article_container">
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->


@push('scripts')
<script>
    $(function () {

        $('#search_modal_article_container').on('click', '.search_article_link', function () {

            var link = $(this).data('link');

            window.open(link,  '_self');
        })

        $('#header_search').click(function () {

            search($('#header_search_content').val(), function () {

                $('#search_modal').modal('show');
            });
        });

        $('#header_search_content').keypress( function (e) {

            if (e.which === 13) {

                search(this.value, function () {

                    $('#search_modal').modal('show');
                });
            }
        });

        $('#modal_search_content').keypress( function (e) {

            if (e.which === 13) {

                search(this.value);
            }
        });

        $('#modal_search').click(function () {

            search($('#modal_search_content').val());
        });
    });

    function search (query, callback) {

        $('#modal_search_content').val(query);

        $.post('/search', {query: query}, function (data) {

            $('#search_modal_article_container').html(data);

            if (callback) {

                callback();
            }
        });
    }
</script>
@endpush
