@if(!isset($hide_hellobar))
    <style>
        .glyphicon-remove {
            color: red;
        }

        .glyphicon-ok {
            color: green;
        }

        .subscription_container {
            overflow: hidden;
            text-align: center;
            padding: 2px;
            z-index: 999;
            position: absolute;
            top: 39px;
            left: 0;
        }

        #subscription_questions {
            background-color: white;
            box-shadow: 0 1px 5px rgba(0, 0, 0, .5);
        }

        #country ~ span {
            right: 5px;
        }

        .subscription_container {
            display: none;
        }

        .subscription_button_div {

            padding: 5px;
        }
    </style>

    @inject('countries', 'Webpatser\Countries\Countries')
    @inject('subscriber_age_group', 'App\SubscriberAgeGroup')
    @inject('subscriber_education_level', 'App\SubscriberEducationLevel')
    @inject('subscriber_income_bracket', 'App\SubscriberIncomeBracket')
    @inject('subscriber_industry', 'App\SubscriberIndustry')
    @inject('subscriber_position', 'App\SubscriberPosition')
    @inject('subscriber_purchase_input', 'App\SubscriberPurchaseInput')
    @inject('subscriber_source', 'App\SubscriberSource')
    @inject('request', request)

    @if(!isset($request->newsletter) && !$request->cookie('subscriber_bar_check'))
        <div id='bizzbar'>
            <div class="form-inline">
                <div class="col-md-3 col-md-offset-2 no-padding">
                    <p style="display: inline-block;" class="pull-right">
                        Drive attention to your website content with Bizz Bar.
                    </p>
                </div>
                <div class="col-md-3 no-padding">
                    @include('admin.subscribers.partials.subscriptions', ['subscriptions' => ['magazine' => 'Print Magazine', 'digital' => 'Digital Magazine', 'newsletter' => 'Newsletter']])
                </div>
                <div class="col-md-2 no-padding" style="padding: 5px;">
                    <div class="pull-left form-group">
                        {!! Form::text('email', NULL, ['id' => 'email', 'class' => 'form-control subscriber_data', 'placeholder' => 'Enter your Email', 'style' => 'width: 100%;']) !!}
                    </div>
                    <input id="subscribe" type="submit" class="pull-left btn btn-primary" style="margin-left: 10px;">
                </div>
            </div>
            <close></close>
        </div>
        <open>Click Here To Subscribe</open>
        <div id="subscribe_error_message" class="subscription_container col-md-4 col-md-offset-4 alert alert-danger" role="alert">
            <h3>This email already exists in our systems</h3>
            <div class="form-group">
                <button id="subscribe_error_message_email" class="btn btn-default btn-large">Need to update your subscription? Click Here!</button>
            </div>
        </div>
        <div id="subscribe_email_sent" class="subscription_container col-md-4 col-md-offset-4 alert alert-success" role="alert">
            <h3>This Email has been sent.</h3>
        </div>
        <div id="subscribe_thankyou" class="subscription_container col-md-4 col-md-offset-4 alert alert-success" role="alert">
            <h3>Thankyou for subscribing</h3>
        </div>
        <div id="subscription_container" class="subscription_container col-md-4 col-md-offset-4">
            <div id="subscription_questions" class="col-md-12">

                <button type="button" class="subscription_questions_cancel close" data-dismiss="modal" aria-label="Close" style="margin-top: 10px;">
                    <span class="glyphicon glyphicon-remove" style="color: black;" aria-hidden="true"></span>
                </button>

            @include('admin.subscribers.partials.personal_information', ['countries' => $countries->orderBy('full_name')->pluck('full_name', 'id')])

            @include('admin.subscribers.partials.questions', [
            'industry' => $subscriber_industry->orderBy('name')->pluck('name', 'id'),
            'position' => $subscriber_position->orderBy('name')->pluck('name', 'id'),
            'education_level' => $subscriber_education_level->orderBy('name')->pluck('name', 'id'),
            'purchase_input' => $subscriber_purchase_input->orderBy('name')->pluck('name', 'id'),
            'income_bracket' => $subscriber_income_bracket->orderBy('name')->pluck('name', 'id'),
            'age_group' => $subscriber_age_group->orderBy('name')->pluck('name', 'id'),
            ])

            <!-- Subscriber id Form Hidden -->
            {!! Form::hidden('subscriber_id', NULL, ['id' => 'subscriber_id', 'class' => 'subscriber_data']) !!}

            <!-- Form Submit -->
                <div class="form-group">
                    {!! Form::submit('Submit', ['id' => 'subscription_questions_submit', 'class' => 'btn btn-primary form-control']) !!}
                </div>
                <div id="error_message" class="alert alert-danger" role="alert">Please complete the form.</div>
            </div>
        </div>
    @endif
    @push('scripts')
        <script>

            "use strict";

            $(function () {

                /**
                 *
                 * bizzbar section used to control the main subscriber bar
                 *
                 */
                /*$("#bizzbar").delay(1000).slideDown('slow').delay(3000).slideUp('slow', function () {

                    $("open").slideDown('slow');
                });*/

                $('#email').click(function () {

                    console.log('Email Clicked');

                    $('#subscribe_error_message').hide();
                    stop_bizzbar();
                });

                $("open").click(function () {

                    bizzbar_down();
                });

                $("close").click(function () {

                    bizzbar_up();
                });

                //keep track of scroll position when scrolling used to keep questions right under the subscriber bar
                var bizzbar_top = 0;
                var bizzbar_top_anchor = 0;

                $(window).scroll(function () {

                    if (bizzbar_top_anchor >= bizzbar_top) {

                        bizzbar_top_anchor = bizzbar_top;

                        $('.subscription_container').css('top', (subscription_container_offset_top() + 'px'));
                    }

                    bizzbar_top = subscription_container_offset_top();
                });

                /**
                 *
                 * Subscription Error Duplicate Email Section
                 *
                 */

                $('#subscribe_error_message_email').click(function () {

                    stop_subscribe_error_message();

                    var email = $('#email').val();

                    if (email !== '') {

                        $.post('/subscriber/update_subscriber_email', {email: email}, function (data) {

                            $('#subscribe_error_message').slideUp(function () {

                                $('#subscribe_email_sent').slideDown().delay(3500).slideUp();
                            });
                        }).fail(function () {

                            $('h3', '#subscribe_email_sent').html(data);

                            $('#subscribe_email_sent').html(data).slideDown().delay(3500).slideUp();
                        });
                    }
                });

                /**
                 *
                 * Subscription Cancel for Secondary Subscription Items (Questions and Magazine Information)
                 *
                 */
                $('.subscription_questions_cancel').click(function () {

                    $('#subscription_container').slideUp(function () {

                        $('#subscribe_thankyou').slideDown().delay(2500).slideUp();
                    });
                });

                /**
                 *
                 * First Subscribe Button Submission for Newsletter, Digital, Magazine, and Email.
                 *
                 */

                $('#subscribe').click(function () {

                    //set the second subscriber bar to the correct height from top
                    $('#subscription_container').css('top', subscription_container_offset_top() + 'px');
                    $('#subscribe_error_message').css('top', subscribe_error_message_offset_top() + 'px');
                    bizzbar_top_anchor = subscription_container_offset_top();

                    var email = $('#email').val();
                    var subscriptions = $('.subscriptions').map(function () {

                        if (this.value !== '')
                            return this.value;
                    }).get();

                    if (email !== '' && subscriptions.length > 0) {

                        var subscriber_data = $('.subscriber_data').not('#magazine_hidden_subscription').serializeArray();

                        $.post('/subscriber', subscriber_data, function (data) {

                            $('#subscriber_id').val(data);

                            $('#subscription_container').slideDown();
                        }).fail(function () {

                            $('#subscribe_error_message').slideDown().delay(4000).slideUp();
                        });

                    }
                });

                /**
                 *
                 * Second Subscribe Button Submission for the Questions and Magazine Address Information
                 *
                 */
                $('#subscription_questions_submit').click(function () {

                    if ($('#magazine_subscription').data('checked') === 'checked' && $('.magazine_subscription_information').parent('div.has-error').length > 0) {

                        var error_message = $('#error_message').slideDown();

                        setTimeout(function () {

                            error_message.slideUp();
                        }, 5000);
                    } else {

                        var subscriber_id = $('#subscriber_id').val();
                        var subscriber_data = $('.subscriber_data').serializeArray();

                        subscriber_data.push({name: '_method', value: 'PATCH'});

                        $.post('/subscriber/' + subscriber_id, subscriber_data, function () {

                            $('#subscription_container').slideUp(function () {

                                $('#subscribe_thankyou').slideDown().delay(2500).slideUp();
                            });
                        });
                    }
                });
            });

            function subscription_container_offset_top() {

                return $('#bizzbar').offset().top + 39;
            }

            function subscribe_error_message_offset_top() {

                return $('#bizzbar').offset().top + 41;
            }

            function bizzbar_down() {

                $("open").slideUp(function () {

                    $("#bizzbar").slideDown();
                });
            }

            function bizzbar_up() {

                $("#bizzbar").slideUp(function () {

                    $("open").slideDown();
                });
            }

            function stop_bizzbar() {

                $("#bizzbar").stop(true);
                $("open").stop(true);
            }

            function stop_subscribe_error_message() {

                $('#subscribe_error_message').stop(true);
            }
        </script>
    @endpush
@endif