@extends('layouts.site')

@push('meta')
    <title>Privacy Policy - The Maritime Executive</title>
    <meta name="description" content="Please view our privacy policy page for a complete overview of information collected and practices used to protect your privacy. ">
    <meta name="keywords" content="">
    <meta property="og:title" content="Privacy Policy - The Maritime Executive">
    <meta property="og:url" content="https://maritime-executive.com/privacy-policy">
    <meta property="og:description" content="Please view our privacy policy page for a complete overview of information collected and practices used to protect your privacy. ">
@endpush

@section('content')
    <section class="wrap-content">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                  
					<h4 class="bl-6 b-color-4 col-md-6 text-uppercase">
                        <span class="bold red">MarEx</span> PrivacyPolicy
                    </h4>
					<div class="clearfix"></div>
                    <p>
                        <b>The Maritime Executive provides premium news, insight and analysis to a growing audience of global decision makers. We have held true to our values of integrity, authority and independence for more than 20 years. Central to this mission is our commitment to upholding the highest standards of data protection for our customers.</b>
                    </p>
                    <p>This Privacy Policy applies to all websites and web applications which link to this policy and are published by The Maritime Executive (“Sites”).</p>
                    <p>If you wish to amend any of the personal information that we hold about you, or update your marketing preferences, you can do so at any time through your account.</p>
                    <p>If you have any queries about how we use your personal information, please contact our Data Protection Officer at <a href="mailto:Info@maritime-executive.com">Info@maritime-executive.com</a>.</p>

                    <h2>Information we collect</h2>
                    <p>This section details the information we may collect about you. We explain why, and how, we use it in later sections.</p>

                    <h2>Account information</h2>
                    <p>If you decide to create an account or enquire about one of our products or services, we’ll ask you to provide us with some specific information, for example:</p>
                    <ul>
                        <li><b>Basic personal details</b> - such as name, title and date of birth;</li>
                        <li><b>Personal contact details</b> - such as home address, delivery address, home phone number, mobile phone number, and email address;</li>
                        <li><b>Work details</b> - such as job title, department, company name, company address, work email address and office phone number;</li>
                        <li><b>Log in details</b> - such as username and password;</li>
                        <li><b>Payment details</b> - such as your bank account and payment card information.</li>
                    </ul>

                    <h2>Additional information</h2>
                    <p>On occasion, we will ask you to voluntarily provide additional information, for example:</p>
                    <ul>
                        <li>Your opinion of our products and services;</li>
                        <li>Your preferences, including newsletters or my MarEx topics;</li>
                        <li>Your career details and CV if you use The Maritime Executive Jobs Board or our other recruitment pages;</li>
                    </ul>

                    <h2>Information we obtain from partners and public sources</h2>
                    <p>In some circumstances, we collect information about you from our media partners at trade shows, conferences and events to help us better understand our audience and enhance the relevance of our content.</p>

                    <h2>Information we obtain through cookies and similar tools</h2>
                    <p>We use cookies (and similar technologies) and analytics tools across our website and newsletter and print circulation to collect information about you. This information can be used to improve the performance of the site, make advertising more relevant and enhance your user experience. We provide detailed information about cookies and similar technologies within our <a href="https://help.ft.com/help/legal-privacy/cookies/" target="_blank">Cookie Policy</a>; examples include:</p>
                    <ul>
                        <li><b>Your location</b> - we use cookies to display the version of the site that is most relevant to your location. For example, if you log in to maritime-executive.com from the U.S. or Europe or other areas in the world, our cookies capture that information used for our semi-annual audits by the Alliance of Audit Media.</li>
                        <li><b>Your usage</b> - we use cookies to understand how our customers use our website and interact with our communications and journalism. For example, we use technology on our website and newsletter, which records user movements, including page scrolling, clicks and text entered. (It does not record payment details.) This helps us to identify usability issues and improve the assistance we can provide to users and is also used for aggregated and statistical reporting purposes.</li>
                        <li><b>Your device</b> - we use cookies to understand what type of device you are using to show you the best version of the site.</li>
                        <li><b>Your engagement with advertisements</b> - we use cookies to understand what advertisements you have been shown, or clicked on, to bill our advertising partners, and to present you with advertisements that are more relevant to you.</li>
                    </ul>
                    <p>If you wish to manage your cookies, please follow the instructions in the “How to manage cookies” section within our <a href="https://help.ft.com/help/legal-privacy/cookies/" target="_blank">Cookie Policy</a>.</p>

                    <h2>Lawful basis for processing</h2>
                    <p>We only process personal information where we have a lawful basis for doing so, such as the following:</p>
                    <ul>
                        <li><b>User consent</b> - This is where you have given us explicit permission to process personal information for a given purpose. For example, if you complete one of our general enquiry forms, we would ask for your consent if we wanted to use your personal information for any other purpose. You have the right to withdraw this consent at any time. You can manage your preferences within your account or by contacting customer services.</li>
                        <li><b>Legitimate business purposes</b> - This is where we have a legitimate interest, as a business, to process personal information. For example, where we are aware of copyright infringements on our website and newsletter, it is in our legitimate interests as a business to identify those responsible. We take due care to balance our interests against your right to privacy.</li>
                        <li><b>Contractual necessity</b> - This is where we have to process personal information to meet our contractual obligations. For example, if you are a print subscriber, we would need to process your delivery address to fulfil your subscription.</li>
                        <li><b>Legal obligation</b> - This is where we have to process personal information in order to comply with the law. For example, we process and retain customer invoice information to comply with financial regulations.</li>
                    </ul>

                    <h2>How we use your personal information</h2>
                    <p>We collect personal information for eight main reasons:</p>
                    <ol>
                        <li><b>To provide our service</b> - We require some of your basic personal information so our services work as you would expect, for example, delivering the print magazine to your correct address, providing access to our digital content, notifying you of changes to our services and dealing with customer services queries.</li>
                        <li><b>To improve and maintain performance</b> - In order to provide you with the best possible user experience, we need to make sure that our products and services work as they should. Using personal information helps us understand how our readers use our website and newsletter so we can make improvements. This includes testing proposed developments on our Sites, reaching out to our customers with article comments by our readers, which remain posted on our systems.</li>
                        <li><b>To bill our customers</b> - We, along with our authorized payments processors, securely process your payment information to take payments, give refunds and to detect and prevent fraudulent activity. We will also update your payment information, in the event that a payment is unsuccessful. You can manage your payment information at any time by contacting customer services. If your subscription is provided by your employer or educational institution under a group subscription, we will report how active you are for the purposes of billing.</li>
                        <li><b>To monitor compliance with our policies and terms</b> - We monitor for breaches of our terms and conditions and copyright policies. For example, we reserve the right to inform the subscription holder if, through use of a group subscription, you are using our content in breach of the terms and conditions or copyright policies of our original content. We also monitor activity on our website and newsletter to detect and prevent invalid or fraudulent traffic.</li>
                        <li><b>To personalize our products and services</b> - We improve your experience of our products and services by personalizing parts of our website and newsletter with the information you give us and what we learn about you. This includes showing you articles you may be interested in and recommending editions of The Maritime Executive, industry events and conferences via emails you may wish to sign up to. Where our website have such functionality, you can manage elements of personalization in your account.</li>
                        <li><b>To communicate product changes and offers</b> - We want you to get the most out of our products and services, including showcasing our latest content and newsletters. We will contact you with carefully-curated media e-blast offers and promotions, exclusive event invitations and feature announcements. For example, if there are no updates on topics you follow in newsletter, we will send you articles on other topics that we think you might be interested in. You are able to change your preferences at any time through your account or by contacting customer services. We personalize our communications for strategic purposes. For example, we might offer group subscriptions to corporate managers or various organizations.</li>
                        <li><b>For the purpose of advertising</b> - We rely on advertising revenue in part to support our award-winning journalism. We need to process your information to understand the effectiveness of the advertising we serve to you and others, and to deliver relevant personalized advertising. We use the information you give us and the information we collect about you to serve you with the most appropriate advertisements. You can manage your advertising settings for our websites and newsletter that carry out this activity in your account. If you do decide to turn off personalized advertisements or advertisements tailored to you, you will still see the same number of advertisements but they may be less relevant to you. You may continue to see advertisements that are targeted to you based on other non-personal information, for example, the article that you are reading.</li>
                    </ol>

                    <h2>Who we share your personal information with</h2>
                    <p>We disclose personal information to facilitate the running of our business or to provide specific services you have requested. Commonly, we will disclose information to:</p>
                    <ul>
                        <li><b>Service providers</b> - We engage service providers who help to support our business and improve our products. These service providers include, for example, fulfilment providers for delivery of our digital content and marketing to Liquid Web, which hosts our website and newsletter databases. We also work with various distribution partners to deliver print subscriptions. We have contracts in place with these data processors and they can only use your personal information under our instruction. For example, if you have a print subscription with us, we will disclose your information (address, contact details) to our distribution partners to facilitate delivery of the newsletter or magazine.</li>
                        <li><b>Advertisers</b> - We, and our advertising partners, use cookies to collect personal information and serve you with advertisements that we believe are relevant to you and your interests. There is more specific information about our advertising partners and data sharing in our <a href="https://help.ft.com/help/legal-privacy/cookies/" target="_blank">Cookie Policy</a>.</li>
                        <li><b>Institutional customers</b> - If your subscription is provided by your employer or educational institution under a group subscription or trial, we will provide your employer or educational institution with information about your level of activity on our website for the purposes of billing. This information is provided at a high-level and your employer cannot track exactly what articles you have read. We may also provide current or prospective institutional clients with activity information about individual subscribers who registered using that entity’s corporate email address. We will always contact individual subscribers before doing so and will respect any requests not to share this information.</li>
                        <li><b>Recruiters</b><br><i>Job Board Applications</i><br>When you apply for jobs through The Maritime Executive Jobs Board your application is forwarded directly to the advertiser of the job that you are applying for (“Recruiters”). Recruiters include agencies who may pass your information to companies that are recruiting in employment field(s) relevant to your interests. Applications that are made through Recruiters’ sites, or other external websites, will be subject to their privacy policies. </li>
                        <li><i>Executive profile and match service</i><br>Users are provided with the option to create a personal Executive Profile and to control access to it through various settings. Profile information includes anything that you provide in the relevant information fields on The Maritime Executive Jobs Board are offered a Match Service which allows authorized Recruiters. Whether your profile is included in the searchable Profile Database will depend on the settings you have chosen.</li>
                        <li>
                            <b>Social media providers</b> - Information will be shared with social media platforms where you log in to our website or newsletter (Google, Linkedin, Twitter and Facebook) via a social media account, or use components on our website provided by social media platforms. We also share the information of our subscribers with social media partners for the following reasons:
                            <ul>
                                <li>To prevent existing subscribers from being targeted with subscription offerings on social media platforms;</li>
                                <li>To create lookalike audiences for the purposes of targeted advertising on social media platforms</li>
                                <li>To encourage users to get the most out of their subscription.</li>
                            </ul>
                        </li>
                        <li><b>Other users</b> - Our website and newsletter are publicly accessible and anyone around the world who accesses our digital information will be able to see anything you post, such as comments about an article. We encourage you to use a pseudonym when commenting on our website if you do not wish to be identifiable to other readers.</li>
                        <li><b>The Maritime Executive group</b> - We share your information within the company to provide our services and to better understand the relationship between our content products. More information about The Maritime Executive is on our “<a href="https://aboutus.ft.com/en-gb/ft-group/" target="_blank">About us</a>” website. For example, The Maritime Executive Newsletter may send exclusive invitations to The Maritime Executive print and online subscribers if an event may be of particular interest to that individual.</li>
                        <li><b>Legal processes and successors in title</b> - We may also disclose your information to comply with applicable laws, court orders or other valid legal processes, and to enforce or apply our terms of use, any subscription agreement, or any of our other rights. We may transfer or disclose your personal information to any entity which may take over or purchase the relevant business. We also share aggregated, non-identifiable information with third parties. Before sharing this information, we ensure that it cannot identify you as an individual. For example, we regularly release information about the size and growth of our audiences.</li>
                    </ul>

                    <h2>How long we retain your personal information</h2>
                    <p>We retain your personal information for as long as your account is active and therefore open; this allows you to continue accessing our content, products and services.</p>
                    <p>If you become inactive and are not a subscriber, we may delete elements of the information associated with your account. We will normally warn you if your access is going to be withdrawn and give you the opportunity to retain your account.</p>
                    <p>Where we don’t need to keep your information in full, we will obfuscate or aggregate it, for example, web activity logs and survey responses. This is to ensure that we do not retain your information for any longer than is necessary.</p>
                    <p>A summary of how long your personal information is retained can be found below:</p>
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>Category of Data</th>
                                    <th>Example</th>
                                    <th>Retention Period</th>
                                    <th>Justification for Retention</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>Billing information</td>
                                    <td>Masked details of most recently used payment method</td>
                                    <td>7 years</td>
                                    <td>For regulatory reasons we are required to retain accounting records for 7 years.</td>
                                </tr>
                                <tr>
                                    <td>Business intelligence</td>
                                    <td>Web activity on maritime-executive.com</td>
                                    <td>36 months (then aggregated + non-personally identifiable)</td>
                                    <td>To improve and maintain performance, personalise our services and to provide our product.</td>
                                </tr>
                                <tr>
                                    <td>Comments</td>
                                    <td>Comment on an online newsletter article</td>
                                    <td>Life of the article</td>
                                    <td>To enable our readers to see other readers’ comments about our content.</td>
                                </tr>
                                <tr>
                                    <td>Customer service queries</td>
                                    <td>Complaint about non-delivery of magazine</td>
                                    <td>7 years</td>
                                    <td>To provide a case history to assist us to answer your queries.</td>
                                </tr>
                                <tr>
                                    <td>Communication history</td>
                                    <td>Email stating that your subscription is up for renewal</td>
                                    <td>7 years</td>
                                    <td>So that we have a record of what communications we have sent to you, to better assist your queries</td>
                                </tr>
                                <tr>
                                    <td>Site features</td>
                                    <td>Portfolio tool information</td>
                                    <td>Lifetime of the account</td>
                                    <td>To improve your experience of our products and services and to enable you to continue accessing site features.</td>
                                </tr>
                                <tr>
                                    <td>Subscription information</td>
                                    <td>Account information relating to a Financial Times newspaper subscription</td>
                                    <td>7 years post-subscription</td>
                                    <td>To enable us to fulfil your contract with us.</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    <p>It is sometimes necessary for us to keep your personal information for longer periods of time, for example:</p>
                    <ul>
                        <li>If there is a statutory requirement to retain it;</li>
                        <li>If we require the information for legal reasons or there is a legitimate business need for us to retain it;</li>
                        <li>To ensure we do not contact you if you have asked us not to.</li>
                    </ul>

                    <h2>How we keep your personal information secure</h2>
                    <p>We have appropriate technical and administrative security measures in place to help ensure that our users’ information is protected against unauthorized or accidental access, use, alteration, or loss. We use encryption technology, such as Transport Layer Security (TLS), to protect your personal information when you order products or services from us. More information about our approach to cyber security can be found in our <a href="https://help.ft.com/help/legal/cyber-security-statement/" target="_blank">Cyber Security Statement</a>.</p>
                    <p>We operate a global business, so your personal information may be processed and stored outside the European Economic Area (EEA). For example, our global customer services team need to access information about you in order to respond to your queries. We put in place safeguards, such as U.S. and E.U. <a href="https://eur-lex.europa.eu/legal-content/en/TXT/?uri=CELEX:32010D0087" target="_blank">standard contractual clauses</a>, to protect information that is transferred in this way.</p>

                    <h2>Your rights</h2>
                    <p>Under data protection laws, you have rights as an individual in relation to the personal data we hold about you. These rights include:</p>
                    <ul>
                        <li>The right to object to direct marketing – your preferences, including in relation to direct marketing, can be found in your account;</li>
                        <li>The right to access the personal data that we process about you;</li>
                        <li>The right to request the deletion of your personal data;</li>
                        <li>The right to request the rectification of your personal data – you can manage some of this information in your account.</li>
                    </ul>
                    <p>You can exercise these rights through your account or by contacting customer services.</p>
                    <p>You also have the right to lodge a complaint with a supervisory authority. In the U.S. and E.U and this is the <a href="https://ico.org.uk/" target="_blank">Information Commissioner’s Offices</a> (ICO).</p>

                    <h2>Where this Privacy Policy applies</h2>
                    <p>Personal information is collected by The Maritime Executive LLC on behalf of  The Maritime Executive Magazine and The Maritime Executive Newsletter. We do not intentionally collect or use any information from children.</p>
                    <p>Our website and newsletter links to third party websites which are not subject to this privacy policy. We are not responsible for their content, use of personal information, or security practices.</p>
                    <p>If you have a query with regards to the processing of your personal information, please contact our Data Protection Officer directly at <a href="mailto:Privacy.Officer@maritime-executuve.com">Privacy.Officer@maritime-executuve.com</a>.</p>

                    <address>You may also write us at:
                        <br>
                        The Maritime Executive LLC
                        <br>
                        3200 S. Andrews Avenue, Suite 100, Fort Lauderdale, FL 33316
                        <br>
                        EIN: 20-5245489
                    </address>

                    <h2>Changes to this Privacy Policy</h2>
                    <p>This policy is effective from 01/01/2018.</p>
                    <p>Any changes we may make to this privacy policy will be posted on this page. If changes are significant, we may choose to notify you by email or to clearly indicate on our home page that the policy has been updated.</p>
                </div>
            </div>
        </div>
    </section>
@endsection
