@extends('layouts.site')

@section('content')
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <a href="/subscriber/send_subscriber_email" target="_blank" class="btn btn-info btn-lg btn-block">Already a subscriber? Click Here!</a>
                <h1>Subscribe</h1>
                {!! Form::open(['action' => 'SubscribersController@store']) !!}
                @if (!$errors->isEmpty())
                <div class="alert alert-danger alert-dismissable">
                    <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                    <p>{{ $errors->first() }}</p>
                </div>
                @endif
                @if (Session::has('error'))
                    <div class="alert alert-danger alert-dismissable">
                        <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                        <p>{{ Session::get('error') }}</p>
                    </div>
                @endif
                @include('admin.subscribers.partials.subscriptions', ['subscriptions' => $subscriptions ?? []])
                <input type="hidden" id="email_marketing_hidden_subscription" name="email_marketing" class="subscriptions subscriber_data" value="1">
                @include('admin.subscribers.form', ['submit_title' => 'Subscribe'])
                {!! Form::close() !!}
            </div>
        </div>
    </div>
@endsection
