@extends('layouts.site')

@section('content')
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    {!! Form::model($subscriber, ['method' => 'PATCH', 'action' => ['SubscribersController@update', $subscriber->id]]) !!}
                    @if (!$errors->isEmpty())
                    <div class="alert alert-danger alert-dismissable">
                        <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                        <p>{{ $errors->first() }}</p>
                    </div>
                    @endif
                    @if (Session::has('error'))
                        <div class="alert alert-danger alert-dismissable">
                            <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                            <p>{{ Session::get('error') }}</p>
                        </div>
                    @endif
                    @include('admin.subscribers.partials.subscriptions', ['subscriptions' => $subscriptions ?? []])
                    @include('admin.subscribers.form', ['submit_title' => 'Update Subscriber'])
                    {!! Form::close() !!}
                </div>
            </div>
        </div>
@endsection
