@if ($paginator->hasPages())
    <ul class="pagination">
        {{-- Previous Page Link --}}
        @if ($paginator->onFirstPage())
            <li class="disabled"><span>&laquo;</span></li>
        @else
            <li><a href="{{ $paginator->previousPageUrl() }}" rel="prev">&laquo;</a></li>
        @endif

        {{-- Pagination Elements --}}
        @foreach ($elements as $element)
            {{-- "Three Dots" Separator --}}
            @if (is_string($element))
                <li class="disabled"><span>{{ $element }}</span></li>
            @endif

            {{-- Array Of Links --}}
            @if (is_array($element))
                @foreach ($element as $page => $url)
                    @if ($page == $paginator->currentPage())
                        <li class="active"><span>{{ $page }}</span></li>
                    @else
                        <li><a href="{{ $url }}">{{ $page }}</a></li>
                    @endif
                @endforeach
            @endif
        @endforeach

        {{-- Next Page Link --}}
        @if ($paginator->hasMorePages())
            <li><a href="{{ $paginator->nextPageUrl() }}" rel="next">&raquo;</a></li>
        @else
            <li class="disabled"><span>&raquo;</span></li>
        @endif
    </ul>
    <div class="form-inline form-paginate">
        <div class="form-group">
            <label for="sel1">Go to page:</label>
            <select class="form-control" id="pageselector">
                @foreach(range(1, $paginator->lastPage()) as $i)
                    @if ($i == $paginator->currentPage())
                        <option value="" selected="selected">{{ $i }}</option>
                    @else
                        <option value="{{ $paginator->url($i) }}">{{ $i }}</option>
                    @endif
                @endforeach
            </select>
        </div>
    </div>
    <style media="screen">
        .form-paginate {
            float: right;
            margin: 20px 0;
        }
    </style>
    <script type="text/javascript">
        document.getElementById('pageselector').onchange = function() {
            window.location = this.value;
        };
    </script>
@endif
