---
layout: simple
title: Examples
description: Quickly get a project started with any of our examples ranging from using parts of the framework to custom components and layouts.
redirect_from:
  - /examples/
---

[Download the Bootstrap source code]({{ site.download.source }}) to snag these examples.

## Framework

Examples that focus on implementing uses of built-in components provided by Bootstrap.

<div class="row bd-examples">
  <div class="col-6 col-md-4">
    <a href="{{ site.baseurl }}/docs/{{ site.docs_version }}/examples/starter-template/">
      <img class="img-thumbnail" src="{{ site.baseurl }}/docs/{{ site.docs_version }}/examples/screenshots/starter-template.jpg" alt="">
      <h4>Starter template</h4>
    </a>
    <p>Nothing but the basics: compiled CSS and JavaScript.</p>
  </div>
  <div class="col-6 col-md-4">
    <a href="{{ site.baseurl }}/docs/{{ site.docs_version }}/examples/grid/">
      <img class="img-thumbnail" src="{{ site.baseurl }}/docs/{{ site.docs_version }}/examples/screenshots/grid.jpg" alt="">
      <h4>Grids</h4>
    </a>
    <p>Multiple examples of grid layouts with all four tiers, nesting, and more.</p>
  </div>
  <div class="clearfix hidden-md-up"></div>

  <div class="col-6 col-md-4">
    <a href="{{ site.baseurl }}/docs/{{ site.docs_version }}/examples/jumbotron/">
      <img class="img-thumbnail" src="{{ site.baseurl }}/docs/{{ site.docs_version }}/examples/screenshots/jumbotron.jpg" alt="">
      <h4>Jumbotron</h4>
    </a>
    <p>Build around the jumbotron with a navbar and some basic grid columns.</p>
  </div>
  <div class="col-6 col-md-4">
    <a href="{{ site.baseurl }}/docs/{{ site.docs_version }}/examples/narrow-jumbotron/">
      <img class="img-thumbnail" src="{{ site.baseurl }}/docs/{{ site.docs_version }}/examples/screenshots/jumbotron-narrow.jpg" alt="">
      <h4>Narrow jumbotron</h4>
    </a>
    <p>Build a more custom page by narrowing the default container and jumbotron.</p>
  </div>
</div>

## Navbars

Taking the default navbar component and showing how it can be moved, placed, and extended.

<div class="row bd-examples">
  <div class="col-6 col-md-4">
    <a href="{{ site.baseurl }}/docs/{{ site.docs_version }}/examples/navbars/">
      <img class="img-thumbnail" src="{{ site.baseurl }}/docs/{{ site.docs_version }}/examples/screenshots/navbar.jpg" alt="">
      <h4>Navbar</h4>
    </a>
    <p>Super basic template that includes the navbar along with some additional content.</p>
  </div>
  <div class="col-6 col-md-4">
    <a href="{{ site.baseurl }}/docs/{{ site.docs_version }}/examples/navbar-top/">
      <img class="img-thumbnail" src="{{ site.baseurl }}/docs/{{ site.docs_version }}/examples/screenshots/navbar-static.jpg" alt="">
      <h4>Static top navbar</h4>
    </a>
    <p>Super basic template with a static top navbar along with some additional content.</p>
  </div>
  <div class="clearfix hidden-md-up"></div>

  <div class="col-6 col-md-4">
    <a href="{{ site.baseurl }}/docs/{{ site.docs_version }}/examples/navbar-top-fixed/">
      <img class="img-thumbnail" src="{{ site.baseurl }}/docs/{{ site.docs_version }}/examples/screenshots/navbar-fixed.jpg" alt="">
      <h4>Fixed navbar</h4>
    </a>
    <p>Super basic template with a fixed top navbar along with some additional content.</p>
  </div>
</div>

## Custom components

Brand new components and templates to help folks quickly get started with Bootstrap and demonstrate best practices for adding onto the framework.

<div class="row bd-examples">
  <div class="col-6 col-md-4">
    <a href="{{ site.baseurl }}/docs/{{ site.docs_version }}/examples/album/">
      <img class="img-thumbnail" src="{{ site.baseurl }}/docs/{{ site.docs_version }}/examples/screenshots/album.jpg" alt="">
      <h4>Album</h4>
    </a>
    <p>Simple one-page template for photo galleries, portfolios, and more.</p>
  </div>
  <div class="col-6 col-md-4">
    <a href="{{ site.baseurl }}/docs/{{ site.docs_version }}/examples/cover/">
      <img class="img-thumbnail" src="{{ site.baseurl }}/docs/{{ site.docs_version }}/examples/screenshots/cover.jpg" alt="">
      <h4>Cover</h4>
    </a>
    <p>A one-page template for building simple and beautiful home pages.</p>
  </div>
  <div class="clearfix hidden-md-up"></div>

  <div class="col-6 col-md-4">
    <a href="{{ site.baseurl }}/docs/{{ site.docs_version }}/examples/carousel/">
      <img class="img-thumbnail" src="{{ site.baseurl }}/docs/{{ site.docs_version }}/examples/screenshots/carousel.jpg" alt="">
      <h4>Carousel</h4>
    </a>
    <p>Customize the navbar and carousel, then add some new components.</p>
  </div>
  <div class="col-6 col-md-4">
    <a href="{{ site.baseurl }}/docs/{{ site.docs_version }}/examples/blog/">
      <img class="img-thumbnail" src="{{ site.baseurl }}/docs/{{ site.docs_version }}/examples/screenshots/blog.jpg" alt="">
      <h4>Blog</h4>
    </a>
    <p>Simple two-column blog layout with custom navigation, header, and type.</p>
  </div>
  <div class="clearfix hidden-md-up"></div>

  <div class="col-6 col-md-4">
    <a href="{{ site.baseurl }}/docs/{{ site.docs_version }}/examples/dashboard/">
      <img class="img-thumbnail" src="{{ site.baseurl }}/docs/{{ site.docs_version }}/examples/screenshots/dashboard.jpg" alt="">
      <h4>Dashboard</h4>
    </a>
    <p>Basic admin dashboard shell with fixed sidebar and navbar.</p>
  </div>
  <div class="col-6 col-md-4">
    <a href="{{ site.baseurl }}/docs/{{ site.docs_version }}/examples/signin/">
      <img class="img-thumbnail" src="{{ site.baseurl }}/docs/{{ site.docs_version }}/examples/screenshots/sign-in.jpg" alt="">
      <h4>Sign-in page</h4>
    </a>
    <p>Custom form layout and design for a simple sign in form.</p>
  </div>
  <div class="clearfix hidden-md-up"></div>

  <div class="col-6 col-md-4">
    <a href="{{ site.baseurl }}/docs/{{ site.docs_version }}/examples/justified-nav/">
      <img class="img-thumbnail" src="{{ site.baseurl }}/docs/{{ site.docs_version }}/examples/screenshots/justified-nav.jpg" alt="">
      <h4>Justified nav</h4>
    </a>
    <p>Create a custom navbar with justified links. Heads up! Not too Safari friendly.</p>
  </div>
  <div class="col-6 col-md-4">
    <a href="{{ site.baseurl }}/docs/{{ site.docs_version }}/examples/sticky-footer/">
      <img class="img-thumbnail" src="{{ site.baseurl }}/docs/{{ site.docs_version }}/examples/screenshots/sticky-footer.jpg" alt="">
      <h4>Sticky footer</h4>
    </a>
    <p>Attach a footer to the bottom of the viewport when the content is shorter than it.</p>
  </div>
  <div class="clearfix hidden-md-up"></div>

  <div class="col-6 col-md-4">
    <a href="{{ site.baseurl }}/docs/{{ site.docs_version }}/examples/sticky-footer-navbar/">
      <img class="img-thumbnail" src="{{ site.baseurl }}/docs/{{ site.docs_version }}/examples/screenshots/sticky-footer-navbar.jpg" alt="">
      <h4>Sticky footer w/ navbar</h4>
    </a>
    <p>Attach a footer to the bottom of the viewport with a fixed top navbar.</p>
  </div>
</div>

## Experiments

Examples that focus on future-friendly features or techniques.

<div class="row bd-examples">
  <div class="col-6 col-md-4">
    <a href="{{ site.baseurl }}/docs/{{ site.docs_version }}/examples/offcanvas/">
      <img class="img-thumbnail" src="{{ site.baseurl }}/docs/{{ site.docs_version }}/examples/screenshots/offcanvas.jpg" alt="">
      <h4>Offcanvas</h4>
    </a>
    <p>Build a toggleable off-canvas navigation menu for use with Bootstrap.</p>
  </div>
</div>
